// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The LinkedOperation. </summary>
    public readonly partial struct LinkedOperation : IEquatable<LinkedOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinkedOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinkedOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string CrossResourceGroupResourceMoveValue = "CrossResourceGroupResourceMove";
        private const string CrossSubscriptionResourceMoveValue = "CrossSubscriptionResourceMove";

        /// <summary> None. </summary>
        public static LinkedOperation None { get; } = new LinkedOperation(NoneValue);
        /// <summary> CrossResourceGroupResourceMove. </summary>
        public static LinkedOperation CrossResourceGroupResourceMove { get; } = new LinkedOperation(CrossResourceGroupResourceMoveValue);
        /// <summary> CrossSubscriptionResourceMove. </summary>
        public static LinkedOperation CrossSubscriptionResourceMove { get; } = new LinkedOperation(CrossSubscriptionResourceMoveValue);
        /// <summary> Determines if two <see cref="LinkedOperation"/> values are the same. </summary>
        public static bool operator ==(LinkedOperation left, LinkedOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinkedOperation"/> values are not the same. </summary>
        public static bool operator !=(LinkedOperation left, LinkedOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinkedOperation"/>. </summary>
        public static implicit operator LinkedOperation(string value) => new LinkedOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinkedOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinkedOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
