// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The LinkedAccessCheck. </summary>
    public partial class LinkedAccessCheck
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LinkedAccessCheck"/>. </summary>
        public LinkedAccessCheck()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinkedAccessCheck"/>. </summary>
        /// <param name="actionName"></param>
        /// <param name="linkedProperty"></param>
        /// <param name="linkedAction"></param>
        /// <param name="linkedActionVerb"></param>
        /// <param name="linkedType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LinkedAccessCheck(string actionName, string linkedProperty, string linkedAction, string linkedActionVerb, string linkedType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionName = actionName;
            LinkedProperty = linkedProperty;
            LinkedAction = linkedAction;
            LinkedActionVerb = linkedActionVerb;
            LinkedType = linkedType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the action name. </summary>
        public string ActionName { get; set; }
        /// <summary> Gets or sets the linked property. </summary>
        public string LinkedProperty { get; set; }
        /// <summary> Gets or sets the linked action. </summary>
        public string LinkedAction { get; set; }
        /// <summary> Gets or sets the linked action verb. </summary>
        public string LinkedActionVerb { get; set; }
        /// <summary> Gets or sets the linked type. </summary>
        public string LinkedType { get; set; }
    }
}
