// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The IdentityManagementType. </summary>
    public readonly partial struct IdentityManagementType : IEquatable<IdentityManagementType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IdentityManagementType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IdentityManagementType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";
        private const string ActorValue = "Actor";
        private const string DelegatedResourceIdentityValue = "DelegatedResourceIdentity";

        /// <summary> NotSpecified. </summary>
        public static IdentityManagementType NotSpecified { get; } = new IdentityManagementType(NotSpecifiedValue);
        /// <summary> SystemAssigned. </summary>
        public static IdentityManagementType SystemAssigned { get; } = new IdentityManagementType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static IdentityManagementType UserAssigned { get; } = new IdentityManagementType(UserAssignedValue);
        /// <summary> Actor. </summary>
        public static IdentityManagementType Actor { get; } = new IdentityManagementType(ActorValue);
        /// <summary> DelegatedResourceIdentity. </summary>
        public static IdentityManagementType DelegatedResourceIdentity { get; } = new IdentityManagementType(DelegatedResourceIdentityValue);
        /// <summary> Determines if two <see cref="IdentityManagementType"/> values are the same. </summary>
        public static bool operator ==(IdentityManagementType left, IdentityManagementType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IdentityManagementType"/> values are not the same. </summary>
        public static bool operator !=(IdentityManagementType left, IdentityManagementType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IdentityManagementType"/>. </summary>
        public static implicit operator IdentityManagementType(string value) => new IdentityManagementType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IdentityManagementType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IdentityManagementType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
