// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The ExtensionOptionType. </summary>
    public readonly partial struct ExtensionOptionType : IEquatable<ExtensionOptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExtensionOptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExtensionOptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string DoNotMergeExistingReadOnlyAndSecretPropertiesValue = "DoNotMergeExistingReadOnlyAndSecretProperties";
        private const string IncludeInternalMetadataValue = "IncludeInternalMetadata";

        /// <summary> NotSpecified. </summary>
        public static ExtensionOptionType NotSpecified { get; } = new ExtensionOptionType(NotSpecifiedValue);
        /// <summary> DoNotMergeExistingReadOnlyAndSecretProperties. </summary>
        public static ExtensionOptionType DoNotMergeExistingReadOnlyAndSecretProperties { get; } = new ExtensionOptionType(DoNotMergeExistingReadOnlyAndSecretPropertiesValue);
        /// <summary> IncludeInternalMetadata. </summary>
        public static ExtensionOptionType IncludeInternalMetadata { get; } = new ExtensionOptionType(IncludeInternalMetadataValue);
        /// <summary> Determines if two <see cref="ExtensionOptionType"/> values are the same. </summary>
        public static bool operator ==(ExtensionOptionType left, ExtensionOptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExtensionOptionType"/> values are not the same. </summary>
        public static bool operator !=(ExtensionOptionType left, ExtensionOptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExtensionOptionType"/>. </summary>
        public static implicit operator ExtensionOptionType(string value) => new ExtensionOptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExtensionOptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExtensionOptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
