// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The DefaultRolloutSpecification. </summary>
    public partial class DefaultRolloutSpecification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DefaultRolloutSpecification"/>. </summary>
        public DefaultRolloutSpecification()
        {
            ResourceTypeRegistrations = new ChangeTrackingList<ResourceTypeRegistrationData>();
        }

        /// <summary> Initializes a new instance of <see cref="DefaultRolloutSpecification"/>. </summary>
        /// <param name="canary"></param>
        /// <param name="lowTraffic"></param>
        /// <param name="mediumTraffic"></param>
        /// <param name="highTraffic"></param>
        /// <param name="restOfTheWorldGroupOne"></param>
        /// <param name="restOfTheWorldGroupTwo"></param>
        /// <param name="providerRegistration"></param>
        /// <param name="resourceTypeRegistrations"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DefaultRolloutSpecification(CanaryTrafficRegionRolloutConfiguration canary, TrafficRegionRolloutConfiguration lowTraffic, TrafficRegionRolloutConfiguration mediumTraffic, TrafficRegionRolloutConfiguration highTraffic, TrafficRegionRolloutConfiguration restOfTheWorldGroupOne, TrafficRegionRolloutConfiguration restOfTheWorldGroupTwo, ProviderRegistrationData providerRegistration, IList<ResourceTypeRegistrationData> resourceTypeRegistrations, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Canary = canary;
            LowTraffic = lowTraffic;
            MediumTraffic = mediumTraffic;
            HighTraffic = highTraffic;
            RestOfTheWorldGroupOne = restOfTheWorldGroupOne;
            RestOfTheWorldGroupTwo = restOfTheWorldGroupTwo;
            ProviderRegistration = providerRegistration;
            ResourceTypeRegistrations = resourceTypeRegistrations;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the canary. </summary>
        public CanaryTrafficRegionRolloutConfiguration Canary { get; set; }
        /// <summary> Gets or sets the low traffic. </summary>
        public TrafficRegionRolloutConfiguration LowTraffic { get; set; }
        /// <summary> Gets or sets the medium traffic. </summary>
        public TrafficRegionRolloutConfiguration MediumTraffic { get; set; }
        /// <summary> Gets or sets the high traffic. </summary>
        public TrafficRegionRolloutConfiguration HighTraffic { get; set; }
        /// <summary> Gets or sets the rest of the world group one. </summary>
        public TrafficRegionRolloutConfiguration RestOfTheWorldGroupOne { get; set; }
        /// <summary> Gets or sets the rest of the world group two. </summary>
        public TrafficRegionRolloutConfiguration RestOfTheWorldGroupTwo { get; set; }
        /// <summary> Gets or sets the provider registration. </summary>
        public ProviderRegistrationData ProviderRegistration { get; set; }
        /// <summary> Gets the resource type registrations. </summary>
        public IList<ResourceTypeRegistrationData> ResourceTypeRegistrations { get; }
    }
}
