// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> The CanaryTrafficRegionRolloutConfiguration. </summary>
    public partial class CanaryTrafficRegionRolloutConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CanaryTrafficRegionRolloutConfiguration"/>. </summary>
        public CanaryTrafficRegionRolloutConfiguration()
        {
            SkipRegions = new ChangeTrackingList<AzureLocation>();
            Regions = new ChangeTrackingList<AzureLocation>();
        }

        /// <summary> Initializes a new instance of <see cref="CanaryTrafficRegionRolloutConfiguration"/>. </summary>
        /// <param name="skipRegions"></param>
        /// <param name="regions"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CanaryTrafficRegionRolloutConfiguration(IList<AzureLocation> skipRegions, IList<AzureLocation> regions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SkipRegions = skipRegions;
            Regions = regions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the skip regions. </summary>
        public IList<AzureLocation> SkipRegions { get; }
        /// <summary> Gets the regions. </summary>
        public IList<AzureLocation> Regions { get; }
    }
}
