// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub
{
    internal class ResourceTypeRegistrationOperationSource : IOperationSource<ResourceTypeRegistrationResource>
    {
        private readonly ArmClient _client;

        internal ResourceTypeRegistrationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ResourceTypeRegistrationResource IOperationSource<ResourceTypeRegistrationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ResourceTypeRegistrationData.DeserializeResourceTypeRegistrationData(document.RootElement);
            return new ResourceTypeRegistrationResource(_client, data);
        }

        async ValueTask<ResourceTypeRegistrationResource> IOperationSource<ResourceTypeRegistrationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ResourceTypeRegistrationData.DeserializeResourceTypeRegistrationData(document.RootElement);
            return new ResourceTypeRegistrationResource(_client, data);
        }
    }
}
