// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub
{
    internal class ProviderRegistrationOperationSource : IOperationSource<ProviderRegistrationResource>
    {
        private readonly ArmClient _client;

        internal ProviderRegistrationOperationSource(ArmClient client)
        {
            _client = client;
        }

        ProviderRegistrationResource IOperationSource<ProviderRegistrationResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ProviderRegistrationData.DeserializeProviderRegistrationData(document.RootElement);
            return new ProviderRegistrationResource(_client, data);
        }

        async ValueTask<ProviderRegistrationResource> IOperationSource<ProviderRegistrationResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ProviderRegistrationData.DeserializeProviderRegistrationData(document.RootElement);
            return new ProviderRegistrationResource(_client, data);
        }
    }
}
