// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ProviderHub
{
    internal class DefaultRolloutOperationSource : IOperationSource<DefaultRolloutResource>
    {
        private readonly ArmClient _client;

        internal DefaultRolloutOperationSource(ArmClient client)
        {
            _client = client;
        }

        DefaultRolloutResource IOperationSource<DefaultRolloutResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DefaultRolloutData.DeserializeDefaultRolloutData(document.RootElement);
            return new DefaultRolloutResource(_client, data);
        }

        async ValueTask<DefaultRolloutResource> IOperationSource<DefaultRolloutResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DefaultRolloutData.DeserializeDefaultRolloutData(document.RootElement);
            return new DefaultRolloutResource(_client, data);
        }
    }
}
