// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ProviderHub.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmProviderHubModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ProviderHub.CustomRolloutData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the rollout. </param>
        /// <returns> A new <see cref="ProviderHub.CustomRolloutData"/> instance for mocking. </returns>
        public static CustomRolloutData CustomRolloutData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CustomRolloutProperties properties = null)
        {
            return new CustomRolloutData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHub.ProviderRegistrationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="ProviderHub.ProviderRegistrationData"/> instance for mocking. </returns>
        public static ProviderRegistrationData ProviderRegistrationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ProviderRegistrationProperties properties = null)
        {
            return new ProviderRegistrationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHub.ResourceTypeRegistrationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="ProviderHub.ResourceTypeRegistrationData"/> instance for mocking. </returns>
        public static ResourceTypeRegistrationData ResourceTypeRegistrationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceTypeRegistrationProperties properties = null)
        {
            return new ResourceTypeRegistrationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TypedErrorInfo"/>. </summary>
        /// <param name="typedErrorInfoType"></param>
        /// <param name="info"> Any object. </param>
        /// <returns> A new <see cref="Models.TypedErrorInfo"/> instance for mocking. </returns>
        public static TypedErrorInfo TypedErrorInfo(string typedErrorInfoType = null, BinaryData info = null)
        {
            return new TypedErrorInfo(typedErrorInfoType, info, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHub.DefaultRolloutData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the rollout. </param>
        /// <returns> A new <see cref="ProviderHub.DefaultRolloutData"/> instance for mocking. </returns>
        public static DefaultRolloutData DefaultRolloutData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DefaultRolloutProperties properties = null)
        {
            return new DefaultRolloutData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceProviderManifest"/>. </summary>
        /// <param name="providerAuthenticationAllowedAudiences"></param>
        /// <param name="providerAuthorizations"></param>
        /// <param name="namespace"></param>
        /// <param name="providerVersion"></param>
        /// <param name="providerType"></param>
        /// <param name="requiredFeatures"></param>
        /// <param name="requiredFeaturesPolicy"></param>
        /// <param name="optInHeaders"></param>
        /// <param name="resourceTypes"></param>
        /// <param name="management"></param>
        /// <param name="capabilities"></param>
        /// <param name="metadata"> Anything. </param>
        /// <param name="globalNotificationEndpoints"></param>
        /// <param name="reRegisterSubscriptionMetadata"></param>
        /// <returns> A new <see cref="Models.ResourceProviderManifest"/> instance for mocking. </returns>
        public static ResourceProviderManifest ResourceProviderManifest(IEnumerable<string> providerAuthenticationAllowedAudiences = null, IEnumerable<ResourceProviderAuthorization> providerAuthorizations = null, string @namespace = null, string providerVersion = null, ResourceProviderType? providerType = null, IEnumerable<string> requiredFeatures = null, FeaturesPolicy? requiredFeaturesPolicy = null, OptInHeaderType? optInHeaders = null, IEnumerable<ProviderResourceType> resourceTypes = null, ResourceProviderManagement management = null, IEnumerable<ResourceProviderCapabilities> capabilities = null, BinaryData metadata = null, IEnumerable<ResourceProviderEndpoint> globalNotificationEndpoints = null, ReRegisterSubscriptionMetadata reRegisterSubscriptionMetadata = null)
        {
            providerAuthenticationAllowedAudiences ??= new List<string>();
            providerAuthorizations ??= new List<ResourceProviderAuthorization>();
            requiredFeatures ??= new List<string>();
            resourceTypes ??= new List<ProviderResourceType>();
            capabilities ??= new List<ResourceProviderCapabilities>();
            globalNotificationEndpoints ??= new List<ResourceProviderEndpoint>();

            return new ResourceProviderManifest(
                providerAuthenticationAllowedAudiences != null ? new ResourceProviderAuthentication(providerAuthenticationAllowedAudiences?.ToList(), serializedAdditionalRawData: null) : null,
                providerAuthorizations?.ToList(),
                @namespace,
                providerVersion,
                providerType,
                requiredFeatures?.ToList(),
                requiredFeaturesPolicy.HasValue ? new FeaturesRule(requiredFeaturesPolicy.Value, serializedAdditionalRawData: null) : null,
                optInHeaders != null ? new RequestHeaderOptions(optInHeaders, serializedAdditionalRawData: null) : null,
                resourceTypes?.ToList(),
                management,
                capabilities?.ToList(),
                metadata,
                globalNotificationEndpoints?.ToList(),
                reRegisterSubscriptionMetadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProviderResourceType"/>. </summary>
        /// <param name="name"></param>
        /// <param name="routingType"></param>
        /// <param name="resourceValidation"></param>
        /// <param name="allowedUnauthorizedActions"></param>
        /// <param name="authorizationActionMappings"></param>
        /// <param name="linkedAccessChecks"></param>
        /// <param name="defaultApiVersion"></param>
        /// <param name="loggingRules"></param>
        /// <param name="throttlingRules"></param>
        /// <param name="endpoints"></param>
        /// <param name="marketplaceType"></param>
        /// <param name="managementType"></param>
        /// <param name="metadata"> Anything. </param>
        /// <param name="requiredFeatures"></param>
        /// <param name="requiredFeaturesPolicy"></param>
        /// <param name="subscriptionStateRules"></param>
        /// <param name="serviceTreeInfos"></param>
        /// <param name="optInHeaders"></param>
        /// <param name="skuLink"></param>
        /// <param name="disallowedActionVerbs"></param>
        /// <param name="templateDeploymentPolicy"></param>
        /// <param name="extendedLocations"></param>
        /// <param name="linkedOperationRules"></param>
        /// <param name="resourceDeletionPolicy"></param>
        /// <returns> A new <see cref="Models.ProviderResourceType"/> instance for mocking. </returns>
        public static ProviderResourceType ProviderResourceType(string name = null, ResourceRoutingType? routingType = null, ResourceValidation? resourceValidation = null, IEnumerable<string> allowedUnauthorizedActions = null, IEnumerable<AuthorizationActionMapping> authorizationActionMappings = null, IEnumerable<LinkedAccessCheck> linkedAccessChecks = null, string defaultApiVersion = null, IEnumerable<LoggingRule> loggingRules = null, IEnumerable<ThrottlingRule> throttlingRules = null, IEnumerable<ResourceProviderEndpoint> endpoints = null, MarketplaceType? marketplaceType = null, IdentityManagementType? managementType = null, BinaryData metadata = null, IEnumerable<string> requiredFeatures = null, FeaturesPolicy? requiredFeaturesPolicy = null, IEnumerable<ProviderSubscriptionStateRule> subscriptionStateRules = null, IEnumerable<ServiceTreeInfo> serviceTreeInfos = null, OptInHeaderType? optInHeaders = null, string skuLink = null, IEnumerable<string> disallowedActionVerbs = null, TemplateDeploymentPolicy templateDeploymentPolicy = null, IEnumerable<ProviderHubExtendedLocationOptions> extendedLocations = null, IEnumerable<LinkedOperationRule> linkedOperationRules = null, ManifestResourceDeletionPolicy? resourceDeletionPolicy = null)
        {
            allowedUnauthorizedActions ??= new List<string>();
            authorizationActionMappings ??= new List<AuthorizationActionMapping>();
            linkedAccessChecks ??= new List<LinkedAccessCheck>();
            loggingRules ??= new List<LoggingRule>();
            throttlingRules ??= new List<ThrottlingRule>();
            endpoints ??= new List<ResourceProviderEndpoint>();
            requiredFeatures ??= new List<string>();
            subscriptionStateRules ??= new List<ProviderSubscriptionStateRule>();
            serviceTreeInfos ??= new List<ServiceTreeInfo>();
            disallowedActionVerbs ??= new List<string>();
            extendedLocations ??= new List<ProviderHubExtendedLocationOptions>();
            linkedOperationRules ??= new List<LinkedOperationRule>();

            return new ProviderResourceType(
                name,
                routingType,
                resourceValidation,
                allowedUnauthorizedActions?.ToList(),
                authorizationActionMappings?.ToList(),
                linkedAccessChecks?.ToList(),
                defaultApiVersion,
                loggingRules?.ToList(),
                throttlingRules?.ToList(),
                endpoints?.ToList(),
                marketplaceType,
                managementType != null ? new IdentityManagement(managementType, serializedAdditionalRawData: null) : null,
                metadata,
                requiredFeatures?.ToList(),
                requiredFeaturesPolicy.HasValue ? new FeaturesRule(requiredFeaturesPolicy.Value, serializedAdditionalRawData: null) : null,
                subscriptionStateRules?.ToList(),
                serviceTreeInfos?.ToList(),
                optInHeaders != null ? new RequestHeaderOptions(optInHeaders, serializedAdditionalRawData: null) : null,
                skuLink,
                disallowedActionVerbs?.ToList(),
                templateDeploymentPolicy,
                extendedLocations?.ToList(),
                linkedOperationRules?.ToList(),
                resourceDeletionPolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceProviderEndpoint"/>. </summary>
        /// <param name="isEnabled"></param>
        /// <param name="apiVersions"></param>
        /// <param name="endpointUri"></param>
        /// <param name="locations"></param>
        /// <param name="requiredFeatures"></param>
        /// <param name="requiredFeaturesPolicy"></param>
        /// <param name="timeout"></param>
        /// <returns> A new <see cref="Models.ResourceProviderEndpoint"/> instance for mocking. </returns>
        public static ResourceProviderEndpoint ResourceProviderEndpoint(bool? isEnabled = null, IEnumerable<string> apiVersions = null, Uri endpointUri = null, IEnumerable<AzureLocation> locations = null, IEnumerable<string> requiredFeatures = null, FeaturesPolicy? requiredFeaturesPolicy = null, TimeSpan? timeout = null)
        {
            apiVersions ??= new List<string>();
            locations ??= new List<AzureLocation>();
            requiredFeatures ??= new List<string>();

            return new ResourceProviderEndpoint(
                isEnabled,
                apiVersions?.ToList(),
                endpointUri,
                locations?.ToList(),
                requiredFeatures?.ToList(),
                requiredFeaturesPolicy.HasValue ? new FeaturesRule(requiredFeaturesPolicy.Value, serializedAdditionalRawData: null) : null,
                timeout,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemplateDeploymentPolicy"/>. </summary>
        /// <param name="capabilities"></param>
        /// <param name="preflightOptions"></param>
        /// <returns> A new <see cref="Models.TemplateDeploymentPolicy"/> instance for mocking. </returns>
        public static TemplateDeploymentPolicy TemplateDeploymentPolicy(TemplateDeploymentCapability capabilities = default, TemplateDeploymentPreflightOption preflightOptions = default)
        {
            return new TemplateDeploymentPolicy(capabilities, preflightOptions, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LinkedOperationRule"/>. </summary>
        /// <param name="linkedOperation"></param>
        /// <param name="linkedAction"></param>
        /// <returns> A new <see cref="Models.LinkedOperationRule"/> instance for mocking. </returns>
        public static LinkedOperationRule LinkedOperationRule(LinkedOperation linkedOperation = default, LinkedAction linkedAction = default)
        {
            return new LinkedOperationRule(linkedOperation, linkedAction, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReRegisterSubscriptionMetadata"/>. </summary>
        /// <param name="isEnabled"></param>
        /// <param name="concurrencyLimit"></param>
        /// <returns> A new <see cref="Models.ReRegisterSubscriptionMetadata"/> instance for mocking. </returns>
        public static ReRegisterSubscriptionMetadata ReRegisterSubscriptionMetadata(bool isEnabled = default, int? concurrencyLimit = null)
        {
            return new ReRegisterSubscriptionMetadata(isEnabled, concurrencyLimit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckinManifestInfo"/>. </summary>
        /// <param name="isCheckedIn"></param>
        /// <param name="statusMessage"></param>
        /// <param name="pullRequest"></param>
        /// <param name="commitId"></param>
        /// <returns> A new <see cref="Models.CheckinManifestInfo"/> instance for mocking. </returns>
        public static CheckinManifestInfo CheckinManifestInfo(bool isCheckedIn = default, string statusMessage = null, string pullRequest = null, string commitId = null)
        {
            return new CheckinManifestInfo(isCheckedIn, statusMessage, pullRequest, commitId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHub.NotificationRegistrationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="ProviderHub.NotificationRegistrationData"/> instance for mocking. </returns>
        public static NotificationRegistrationData NotificationRegistrationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, NotificationRegistrationProperties properties = null)
        {
            return new NotificationRegistrationData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ProviderHub.ResourceTypeSkuData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="ProviderHub.ResourceTypeSkuData"/> instance for mocking. </returns>
        public static ResourceTypeSkuData ResourceTypeSkuData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceTypeSkuProperties properties = null)
        {
            return new ResourceTypeSkuData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }
    }
}
