// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ProviderHub.Models;

namespace Azure.ResourceManager.ProviderHub.Samples
{
    public partial class Sample_NestedResourceTypeSecondSkuCollection
    {
        // Skus_GetNestedResourceTypeSecond
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SkusGetNestedResourceTypeSecond()
        {
            // Generated from example definition: specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/Skus_GetNestedResourceTypeSecond.json
            // this example is just showing the usage of "Skus_GetNestedResourceTypeSecond" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceTypeRegistrationResource created on azure
            // for more information of creating ResourceTypeRegistrationResource, please refer to the document of ResourceTypeRegistrationResource
            string subscriptionId = "ab7a8701-f7ef-471a-a2f4-d0ebbf494f77";
            string providerNamespace = "Microsoft.Contoso";
            string resourceType = "testResourceType";
            ResourceIdentifier resourceTypeRegistrationResourceId = ResourceTypeRegistrationResource.CreateResourceIdentifier(subscriptionId, providerNamespace, resourceType);
            ResourceTypeRegistrationResource resourceTypeRegistration = client.GetResourceTypeRegistrationResource(resourceTypeRegistrationResourceId);

            // get the collection of this NestedResourceTypeSecondSkuResource
            string nestedResourceTypeFirst = "nestedResourceTypeFirst";
            string nestedResourceTypeSecond = "nestedResourceTypeSecond";
            NestedResourceTypeSecondSkuCollection collection = resourceTypeRegistration.GetNestedResourceTypeSecondSkus(nestedResourceTypeFirst, nestedResourceTypeSecond);

            // invoke the operation
            string sku = "testSku";
            NestedResourceTypeSecondSkuResource result = await collection.GetAsync(sku);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ResourceTypeSkuData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Skus_GetNestedResourceTypeSecond
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SkusGetNestedResourceTypeSecond()
        {
            // Generated from example definition: specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/Skus_GetNestedResourceTypeSecond.json
            // this example is just showing the usage of "Skus_GetNestedResourceTypeSecond" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceTypeRegistrationResource created on azure
            // for more information of creating ResourceTypeRegistrationResource, please refer to the document of ResourceTypeRegistrationResource
            string subscriptionId = "ab7a8701-f7ef-471a-a2f4-d0ebbf494f77";
            string providerNamespace = "Microsoft.Contoso";
            string resourceType = "testResourceType";
            ResourceIdentifier resourceTypeRegistrationResourceId = ResourceTypeRegistrationResource.CreateResourceIdentifier(subscriptionId, providerNamespace, resourceType);
            ResourceTypeRegistrationResource resourceTypeRegistration = client.GetResourceTypeRegistrationResource(resourceTypeRegistrationResourceId);

            // get the collection of this NestedResourceTypeSecondSkuResource
            string nestedResourceTypeFirst = "nestedResourceTypeFirst";
            string nestedResourceTypeSecond = "nestedResourceTypeSecond";
            NestedResourceTypeSecondSkuCollection collection = resourceTypeRegistration.GetNestedResourceTypeSecondSkus(nestedResourceTypeFirst, nestedResourceTypeSecond);

            // invoke the operation
            string sku = "testSku";
            bool result = await collection.ExistsAsync(sku);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Skus_GetNestedResourceTypeSecond
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SkusGetNestedResourceTypeSecond()
        {
            // Generated from example definition: specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/Skus_GetNestedResourceTypeSecond.json
            // this example is just showing the usage of "Skus_GetNestedResourceTypeSecond" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceTypeRegistrationResource created on azure
            // for more information of creating ResourceTypeRegistrationResource, please refer to the document of ResourceTypeRegistrationResource
            string subscriptionId = "ab7a8701-f7ef-471a-a2f4-d0ebbf494f77";
            string providerNamespace = "Microsoft.Contoso";
            string resourceType = "testResourceType";
            ResourceIdentifier resourceTypeRegistrationResourceId = ResourceTypeRegistrationResource.CreateResourceIdentifier(subscriptionId, providerNamespace, resourceType);
            ResourceTypeRegistrationResource resourceTypeRegistration = client.GetResourceTypeRegistrationResource(resourceTypeRegistrationResourceId);

            // get the collection of this NestedResourceTypeSecondSkuResource
            string nestedResourceTypeFirst = "nestedResourceTypeFirst";
            string nestedResourceTypeSecond = "nestedResourceTypeSecond";
            NestedResourceTypeSecondSkuCollection collection = resourceTypeRegistration.GetNestedResourceTypeSecondSkus(nestedResourceTypeFirst, nestedResourceTypeSecond);

            // invoke the operation
            string sku = "testSku";
            NullableResponse<NestedResourceTypeSecondSkuResource> response = await collection.GetIfExistsAsync(sku);
            NestedResourceTypeSecondSkuResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ResourceTypeSkuData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Skus_CreateOrUpdateNestedResourceTypeSecond
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SkusCreateOrUpdateNestedResourceTypeSecond()
        {
            // Generated from example definition: specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/Skus_CreateOrUpdateNestedResourceTypeSecond.json
            // this example is just showing the usage of "Skus_CreateOrUpdateNestedResourceTypeSecond" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceTypeRegistrationResource created on azure
            // for more information of creating ResourceTypeRegistrationResource, please refer to the document of ResourceTypeRegistrationResource
            string subscriptionId = "ab7a8701-f7ef-471a-a2f4-d0ebbf494f77";
            string providerNamespace = "Microsoft.Contoso";
            string resourceType = "testResourceType";
            ResourceIdentifier resourceTypeRegistrationResourceId = ResourceTypeRegistrationResource.CreateResourceIdentifier(subscriptionId, providerNamespace, resourceType);
            ResourceTypeRegistrationResource resourceTypeRegistration = client.GetResourceTypeRegistrationResource(resourceTypeRegistrationResourceId);

            // get the collection of this NestedResourceTypeSecondSkuResource
            string nestedResourceTypeFirst = "nestedResourceTypeFirst";
            string nestedResourceTypeSecond = "nestedResourceTypeSecond";
            NestedResourceTypeSecondSkuCollection collection = resourceTypeRegistration.GetNestedResourceTypeSecondSkus(nestedResourceTypeFirst, nestedResourceTypeSecond);

            // invoke the operation
            string sku = "testSku";
            ResourceTypeSkuData data = new ResourceTypeSkuData()
            {
                Properties = new ResourceTypeSkuProperties(new ResourceTypeSkuSetting[]
            {
new ResourceTypeSkuSetting("freeSku")
{
Tier = "Tier1",
Kind = "Standard",
},new ResourceTypeSkuSetting("premiumSku")
{
Tier = "Tier2",
Kind = "Premium",
Costs =
{
new ResourceTypeSkuCost("xxx")
},
}
            }),
            };
            ArmOperation<NestedResourceTypeSecondSkuResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, sku, data);
            NestedResourceTypeSecondSkuResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ResourceTypeSkuData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Skus_ListByResourceTypeRegistrationsNestedResourceTypeSecond
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SkusListByResourceTypeRegistrationsNestedResourceTypeSecond()
        {
            // Generated from example definition: specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/Skus_ListByResourceTypeRegistrationsNestedResourceTypeSecond.json
            // this example is just showing the usage of "Skus_ListByResourceTypeRegistrationsNestedResourceTypeSecond" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceTypeRegistrationResource created on azure
            // for more information of creating ResourceTypeRegistrationResource, please refer to the document of ResourceTypeRegistrationResource
            string subscriptionId = "ab7a8701-f7ef-471a-a2f4-d0ebbf494f77";
            string providerNamespace = "Microsoft.Contoso";
            string resourceType = "testResourceType";
            ResourceIdentifier resourceTypeRegistrationResourceId = ResourceTypeRegistrationResource.CreateResourceIdentifier(subscriptionId, providerNamespace, resourceType);
            ResourceTypeRegistrationResource resourceTypeRegistration = client.GetResourceTypeRegistrationResource(resourceTypeRegistrationResourceId);

            // get the collection of this NestedResourceTypeSecondSkuResource
            string nestedResourceTypeFirst = "nestedResourceTypeFirst";
            string nestedResourceTypeSecond = "nestedResourceTypeSecond";
            NestedResourceTypeSecondSkuCollection collection = resourceTypeRegistration.GetNestedResourceTypeSecondSkus(nestedResourceTypeFirst, nestedResourceTypeSecond);

            // invoke the operation and iterate over the result
            await foreach (NestedResourceTypeSecondSkuResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ResourceTypeSkuData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
