// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PrivateDns.Models
{
    /// <summary> The status of the virtual network link to the Private DNS zone. Possible values are 'InProgress' and 'Done'. This is a read-only property and any attempt to set this value will be ignored. </summary>
    public readonly partial struct VirtualNetworkLinkState : IEquatable<VirtualNetworkLinkState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualNetworkLinkState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualNetworkLinkState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";

        /// <summary> InProgress. </summary>
        public static VirtualNetworkLinkState InProgress { get; } = new VirtualNetworkLinkState(InProgressValue);
        /// <summary> Completed. </summary>
        public static VirtualNetworkLinkState Completed { get; } = new VirtualNetworkLinkState(CompletedValue);
        /// <summary> Determines if two <see cref="VirtualNetworkLinkState"/> values are the same. </summary>
        public static bool operator ==(VirtualNetworkLinkState left, VirtualNetworkLinkState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualNetworkLinkState"/> values are not the same. </summary>
        public static bool operator !=(VirtualNetworkLinkState left, VirtualNetworkLinkState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualNetworkLinkState"/>. </summary>
        public static implicit operator VirtualNetworkLinkState(string value) => new VirtualNetworkLinkState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualNetworkLinkState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualNetworkLinkState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
