// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PrivateDns.Models
{
    /// <summary> The resolution policy on the virtual network link. Only applicable for virtual network links to privatelink zones, and for A,AAAA,CNAME queries. When set to 'NxDomainRedirect', Azure DNS resolver falls back to public resolution if private dns query resolution results in non-existent domain response. </summary>
    public readonly partial struct PrivateDnsResolutionPolicy : IEquatable<PrivateDnsResolutionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrivateDnsResolutionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrivateDnsResolutionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string NxDomainRedirectValue = "NxDomainRedirect";

        /// <summary> Default. </summary>
        public static PrivateDnsResolutionPolicy Default { get; } = new PrivateDnsResolutionPolicy(DefaultValue);
        /// <summary> NxDomainRedirect. </summary>
        public static PrivateDnsResolutionPolicy NxDomainRedirect { get; } = new PrivateDnsResolutionPolicy(NxDomainRedirectValue);
        /// <summary> Determines if two <see cref="PrivateDnsResolutionPolicy"/> values are the same. </summary>
        public static bool operator ==(PrivateDnsResolutionPolicy left, PrivateDnsResolutionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrivateDnsResolutionPolicy"/> values are not the same. </summary>
        public static bool operator !=(PrivateDnsResolutionPolicy left, PrivateDnsResolutionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrivateDnsResolutionPolicy"/>. </summary>
        public static implicit operator PrivateDnsResolutionPolicy(string value) => new PrivateDnsResolutionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrivateDnsResolutionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrivateDnsResolutionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
