// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PrivateDns.Models
{
    /// <summary> The provisioning state of the resource. This is a read-only property and any attempt to set this value will be ignored. </summary>
    public readonly partial struct PrivateDnsProvisioningState : IEquatable<PrivateDnsProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PrivateDnsProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PrivateDnsProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Creating. </summary>
        public static PrivateDnsProvisioningState Creating { get; } = new PrivateDnsProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PrivateDnsProvisioningState Updating { get; } = new PrivateDnsProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static PrivateDnsProvisioningState Deleting { get; } = new PrivateDnsProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static PrivateDnsProvisioningState Succeeded { get; } = new PrivateDnsProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static PrivateDnsProvisioningState Failed { get; } = new PrivateDnsProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static PrivateDnsProvisioningState Canceled { get; } = new PrivateDnsProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="PrivateDnsProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PrivateDnsProvisioningState left, PrivateDnsProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PrivateDnsProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PrivateDnsProvisioningState left, PrivateDnsProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PrivateDnsProvisioningState"/>. </summary>
        public static implicit operator PrivateDnsProvisioningState(string value) => new PrivateDnsProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PrivateDnsProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PrivateDnsProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
