// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PrivateDns
{
    internal class VirtualNetworkLinkOperationSource : IOperationSource<VirtualNetworkLinkResource>
    {
        private readonly ArmClient _client;

        internal VirtualNetworkLinkOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualNetworkLinkResource IOperationSource<VirtualNetworkLinkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualNetworkLinkData.DeserializeVirtualNetworkLinkData(document.RootElement);
            return new VirtualNetworkLinkResource(_client, data);
        }

        async ValueTask<VirtualNetworkLinkResource> IOperationSource<VirtualNetworkLinkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualNetworkLinkData.DeserializeVirtualNetworkLinkData(document.RootElement);
            return new VirtualNetworkLinkResource(_client, data);
        }
    }
}
