// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PowerBIDedicated.Models
{
    /// <summary> The name of the Azure pricing tier to which the SKU applies. </summary>
    public readonly partial struct VCoreSkuTier : IEquatable<VCoreSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VCoreSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VCoreSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoScaleValue = "AutoScale";

        /// <summary> AutoScale. </summary>
        public static VCoreSkuTier AutoScale { get; } = new VCoreSkuTier(AutoScaleValue);
        /// <summary> Determines if two <see cref="VCoreSkuTier"/> values are the same. </summary>
        public static bool operator ==(VCoreSkuTier left, VCoreSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VCoreSkuTier"/> values are not the same. </summary>
        public static bool operator !=(VCoreSkuTier left, VCoreSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VCoreSkuTier"/>. </summary>
        public static implicit operator VCoreSkuTier(string value) => new VCoreSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VCoreSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VCoreSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
