// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PowerBIDedicated.Models
{
    /// <summary> The current deployment state of an auto scale v-core resource. The provisioningState is to indicate states for resource provisioning. </summary>
    public readonly partial struct VCoreProvisioningState : IEquatable<VCoreProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VCoreProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VCoreProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";

        /// <summary> Succeeded. </summary>
        public static VCoreProvisioningState Succeeded { get; } = new VCoreProvisioningState(SucceededValue);
        /// <summary> Determines if two <see cref="VCoreProvisioningState"/> values are the same. </summary>
        public static bool operator ==(VCoreProvisioningState left, VCoreProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VCoreProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(VCoreProvisioningState left, VCoreProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VCoreProvisioningState"/>. </summary>
        public static implicit operator VCoreProvisioningState(string value) => new VCoreProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VCoreProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VCoreProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
