// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PowerBIDedicated.Models
{
    /// <summary> The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning. </summary>
    public readonly partial struct CapacityProvisioningState : IEquatable<CapacityProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CapacityProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CapacityProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string PausedValue = "Paused";
        private const string SuspendedValue = "Suspended";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string SuspendingValue = "Suspending";
        private const string PausingValue = "Pausing";
        private const string ResumingValue = "Resuming";
        private const string PreparingValue = "Preparing";
        private const string ScalingValue = "Scaling";

        /// <summary> Deleting. </summary>
        public static CapacityProvisioningState Deleting { get; } = new CapacityProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static CapacityProvisioningState Succeeded { get; } = new CapacityProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static CapacityProvisioningState Failed { get; } = new CapacityProvisioningState(FailedValue);
        /// <summary> Paused. </summary>
        public static CapacityProvisioningState Paused { get; } = new CapacityProvisioningState(PausedValue);
        /// <summary> Suspended. </summary>
        public static CapacityProvisioningState Suspended { get; } = new CapacityProvisioningState(SuspendedValue);
        /// <summary> Provisioning. </summary>
        public static CapacityProvisioningState Provisioning { get; } = new CapacityProvisioningState(ProvisioningValue);
        /// <summary> Updating. </summary>
        public static CapacityProvisioningState Updating { get; } = new CapacityProvisioningState(UpdatingValue);
        /// <summary> Suspending. </summary>
        public static CapacityProvisioningState Suspending { get; } = new CapacityProvisioningState(SuspendingValue);
        /// <summary> Pausing. </summary>
        public static CapacityProvisioningState Pausing { get; } = new CapacityProvisioningState(PausingValue);
        /// <summary> Resuming. </summary>
        public static CapacityProvisioningState Resuming { get; } = new CapacityProvisioningState(ResumingValue);
        /// <summary> Preparing. </summary>
        public static CapacityProvisioningState Preparing { get; } = new CapacityProvisioningState(PreparingValue);
        /// <summary> Scaling. </summary>
        public static CapacityProvisioningState Scaling { get; } = new CapacityProvisioningState(ScalingValue);
        /// <summary> Determines if two <see cref="CapacityProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CapacityProvisioningState left, CapacityProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CapacityProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CapacityProvisioningState left, CapacityProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CapacityProvisioningState"/>. </summary>
        public static implicit operator CapacityProvisioningState(string value) => new CapacityProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CapacityProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CapacityProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
