// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PowerBIDedicated.Models
{
    /// <summary> Update request specification. </summary>
    public partial class AutoScaleVCorePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoScaleVCorePatch"/>. </summary>
        public AutoScaleVCorePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AutoScaleVCorePatch"/>. </summary>
        /// <param name="sku"> The SKU of the auto scale v-core resource. </param>
        /// <param name="tags"> Key-value pairs of additional provisioning properties. </param>
        /// <param name="capacityLimit"> The maximum capacity of an auto scale v-core resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoScaleVCorePatch(AutoScaleVCoreSku sku, IDictionary<string, string> tags, int? capacityLimit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sku = sku;
            Tags = tags;
            CapacityLimit = capacityLimit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The SKU of the auto scale v-core resource. </summary>
        public AutoScaleVCoreSku Sku { get; set; }
        /// <summary> Key-value pairs of additional provisioning properties. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The maximum capacity of an auto scale v-core resource. </summary>
        public int? CapacityLimit { get; set; }
    }
}
