// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.PowerBIDedicated
{
    internal class DedicatedCapacityOperationSource : IOperationSource<DedicatedCapacityResource>
    {
        private readonly ArmClient _client;

        internal DedicatedCapacityOperationSource(ArmClient client)
        {
            _client = client;
        }

        DedicatedCapacityResource IOperationSource<DedicatedCapacityResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DedicatedCapacityData.DeserializeDedicatedCapacityData(document.RootElement);
            return new DedicatedCapacityResource(_client, data);
        }

        async ValueTask<DedicatedCapacityResource> IOperationSource<DedicatedCapacityResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DedicatedCapacityData.DeserializeDedicatedCapacityData(document.RootElement);
            return new DedicatedCapacityResource(_client, data);
        }
    }
}
