// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.PowerBIDedicated.Models;

namespace Azure.ResourceManager.PowerBIDedicated
{
    /// <summary>
    /// A class representing the DedicatedCapacity data model.
    /// Represents an instance of a Dedicated Capacity resource.
    /// </summary>
    public partial class DedicatedCapacityData : PowerBIDedicatedResourceData
    {
        /// <summary> Initializes a new instance of <see cref="DedicatedCapacityData"/>. </summary>
        /// <param name="location"> Location of the PowerBI Dedicated resource. </param>
        /// <param name="sku"> The SKU of the PowerBI Dedicated capacity resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/> is null. </exception>
        public DedicatedCapacityData(AzureLocation location, CapacitySku sku) : base(location)
        {
            Argument.AssertNotNull(sku, nameof(sku));

            Sku = sku;
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedCapacityData"/>. </summary>
        /// <param name="id"> An identifier that represents the PowerBI Dedicated resource. </param>
        /// <param name="name"> The name of the PowerBI Dedicated resource. </param>
        /// <param name="resourceType"> The type of the PowerBI Dedicated resource. </param>
        /// <param name="location"> Location of the PowerBI Dedicated resource. </param>
        /// <param name="tags"> Key-value pairs of additional resource provisioning properties. </param>
        /// <param name="systemData"> Metadata pertaining to creation and last modification of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sku"> The SKU of the PowerBI Dedicated capacity resource. </param>
        /// <param name="administration"> A collection of Dedicated capacity administrators. </param>
        /// <param name="mode"> Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2). </param>
        /// <param name="tenantId"> Tenant ID for the capacity. Used for creating Pro Plus capacity. </param>
        /// <param name="friendlyName"> Capacity name. </param>
        /// <param name="state"> The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning. </param>
        /// <param name="provisioningState"> The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning. </param>
        internal DedicatedCapacityData(string id, string name, string resourceType, AzureLocation location, IDictionary<string, string> tags, SystemData systemData, IDictionary<string, BinaryData> serializedAdditionalRawData, CapacitySku sku, DedicatedCapacityAdministrators administration, Mode? mode, Guid? tenantId, string friendlyName, State? state, CapacityProvisioningState? provisioningState) : base(id, name, resourceType, location, tags, systemData, serializedAdditionalRawData)
        {
            Sku = sku;
            Administration = administration;
            Mode = mode;
            TenantId = tenantId;
            FriendlyName = friendlyName;
            State = state;
            ProvisioningState = provisioningState;
        }

        /// <summary> Initializes a new instance of <see cref="DedicatedCapacityData"/> for deserialization. </summary>
        internal DedicatedCapacityData()
        {
        }

        /// <summary> The SKU of the PowerBI Dedicated capacity resource. </summary>
        public CapacitySku Sku { get; set; }
        /// <summary> A collection of Dedicated capacity administrators. </summary>
        internal DedicatedCapacityAdministrators Administration { get; set; }
        /// <summary> An array of administrator user identities. </summary>
        public IList<string> AdministrationMembers
        {
            get
            {
                if (Administration is null)
                    Administration = new DedicatedCapacityAdministrators();
                return Administration.Members;
            }
        }

        /// <summary> Specifies the generation of the Power BI Embedded capacity. If no value is specified, the default value 'Gen2' is used. [Learn More](https://docs.microsoft.com/power-bi/developer/embedded/power-bi-embedded-generation-2). </summary>
        public Mode? Mode { get; set; }
        /// <summary> Tenant ID for the capacity. Used for creating Pro Plus capacity. </summary>
        public Guid? TenantId { get; }
        /// <summary> Capacity name. </summary>
        public string FriendlyName { get; }
        /// <summary> The current state of PowerBI Dedicated resource. The state is to indicate more states outside of resource provisioning. </summary>
        public State? State { get; }
        /// <summary> The current deployment state of PowerBI Dedicated resource. The provisioningState is to indicate states for resource provisioning. </summary>
        public CapacityProvisioningState? ProvisioningState { get; }
    }
}
