// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    /// <summary>
    /// A class representing the VirtualEndpointResource data model.
    /// Represents a virtual endpoint for a server.
    /// </summary>
    public partial class VirtualEndpointResourceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualEndpointResourceData"/>. </summary>
        public VirtualEndpointResourceData()
        {
            Members = new ChangeTrackingList<string>();
            VirtualEndpoints = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VirtualEndpointResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="endpointType"> The endpoint type for the virtual endpoint. </param>
        /// <param name="members"> List of members for a virtual endpoint. </param>
        /// <param name="virtualEndpoints"> List of virtual endpoints for a server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualEndpointResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, VirtualEndpointType? endpointType, IList<string> members, IReadOnlyList<string> virtualEndpoints, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            EndpointType = endpointType;
            Members = members;
            VirtualEndpoints = virtualEndpoints;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The endpoint type for the virtual endpoint. </summary>
        [WirePath("properties.endpointType")]
        public VirtualEndpointType? EndpointType { get; set; }
        /// <summary> List of members for a virtual endpoint. </summary>
        [WirePath("properties.members")]
        public IList<string> Members { get; }
        /// <summary> List of virtual endpoints for a server. </summary>
        [WirePath("properties.virtualEndpoints")]
        public IReadOnlyList<string> VirtualEndpoints { get; }
    }
}
