// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    /// <summary>
    /// A class representing a collection of <see cref="ServerThreatProtectionSettingsModelResource"/> and their operations.
    /// Each <see cref="ServerThreatProtectionSettingsModelResource"/> in the collection will belong to the same instance of <see cref="PostgreSqlFlexibleServerResource"/>.
    /// To get a <see cref="ServerThreatProtectionSettingsModelCollection"/> instance call the GetServerThreatProtectionSettingsModels method from an instance of <see cref="PostgreSqlFlexibleServerResource"/>.
    /// </summary>
    public partial class ServerThreatProtectionSettingsModelCollection : ArmCollection, IEnumerable<ServerThreatProtectionSettingsModelResource>, IAsyncEnumerable<ServerThreatProtectionSettingsModelResource>
    {
        private readonly ClientDiagnostics _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics;
        private readonly ServerThreatProtectionSettingsRestOperations _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServerThreatProtectionSettingsModelCollection"/> class for mocking. </summary>
        protected ServerThreatProtectionSettingsModelCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServerThreatProtectionSettingsModelCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServerThreatProtectionSettingsModelCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.PostgreSql.FlexibleServers", ServerThreatProtectionSettingsModelResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServerThreatProtectionSettingsModelResource.ResourceType, out string serverThreatProtectionSettingsModelServerThreatProtectionSettingsApiVersion);
            _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient = new ServerThreatProtectionSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serverThreatProtectionSettingsModelServerThreatProtectionSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != PostgreSqlFlexibleServerResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, PostgreSqlFlexibleServerResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a server's Advanced Threat Protection settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="data"> The Advanced Threat Protection state for the flexible server. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServerThreatProtectionSettingsModelResource>> CreateOrUpdateAsync(WaitUntil waitUntil, ThreatProtectionName threatProtectionName, ServerThreatProtectionSettingsModelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, data, cancellationToken).ConfigureAwait(false);
                var operation = new FlexibleServersArmOperation<ServerThreatProtectionSettingsModelResource>(new ServerThreatProtectionSettingsModelOperationSource(Client), _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics, Pipeline, _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a server's Advanced Threat Protection settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="data"> The Advanced Threat Protection state for the flexible server. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServerThreatProtectionSettingsModelResource> CreateOrUpdate(WaitUntil waitUntil, ThreatProtectionName threatProtectionName, ServerThreatProtectionSettingsModelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, data, cancellationToken);
                var operation = new FlexibleServersArmOperation<ServerThreatProtectionSettingsModelResource>(new ServerThreatProtectionSettingsModelOperationSource(Client), _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics, Pipeline, _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server's Advanced Threat Protection settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServerThreatProtectionSettingsModelResource>> GetAsync(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.Get");
            scope.Start();
            try
            {
                var response = await _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerThreatProtectionSettingsModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server's Advanced Threat Protection settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServerThreatProtectionSettingsModelResource> Get(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.Get");
            scope.Start();
            try
            {
                var response = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerThreatProtectionSettingsModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a list of server's Threat Protection state.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServerThreatProtectionSettingsModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServerThreatProtectionSettingsModelResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServerThreatProtectionSettingsModelResource(Client, ServerThreatProtectionSettingsModelData.DeserializeServerThreatProtectionSettingsModelData(e)), _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics, Pipeline, "ServerThreatProtectionSettingsModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get a list of server's Threat Protection state.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServerThreatProtectionSettingsModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServerThreatProtectionSettingsModelResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServerThreatProtectionSettingsModelResource(Client, ServerThreatProtectionSettingsModelData.DeserializeServerThreatProtectionSettingsModelData(e)), _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics, Pipeline, "ServerThreatProtectionSettingsModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.Exists");
            scope.Start();
            try
            {
                var response = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<ServerThreatProtectionSettingsModelResource>> GetIfExistsAsync(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServerThreatProtectionSettingsModelResource>(response.GetRawResponse());
                return Response.FromValue(new ServerThreatProtectionSettingsModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerThreatProtectionSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-08-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerThreatProtectionSettingsModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="threatProtectionName"> The name of the Threat Protection state. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<ServerThreatProtectionSettingsModelResource> GetIfExists(ThreatProtectionName threatProtectionName, CancellationToken cancellationToken = default)
        {
            using var scope = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsClientDiagnostics.CreateScope("ServerThreatProtectionSettingsModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serverThreatProtectionSettingsModelServerThreatProtectionSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, threatProtectionName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServerThreatProtectionSettingsModelResource>(response.GetRawResponse());
                return Response.FromValue(new ServerThreatProtectionSettingsModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServerThreatProtectionSettingsModelResource> IEnumerable<ServerThreatProtectionSettingsModelResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServerThreatProtectionSettingsModelResource> IAsyncEnumerable<ServerThreatProtectionSettingsModelResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
