// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    internal partial class MigrationsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of MigrationsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public MigrationsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-08-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateCreateRequestUri(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateRequest(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates a new migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="data"> The required parameters for creating a migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/>, <paramref name="migrationName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PostgreSqlMigrationData>> CreateAsync(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a new migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="data"> The required parameters for creating a migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/>, <paramref name="migrationName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PostgreSqlMigrationData> Create(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets details of a migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PostgreSqlMigrationData>> GetAsync(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((PostgreSqlMigrationData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets details of a migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PostgreSqlMigrationData> Get(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((PostgreSqlMigrationData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateRequestUri(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationPatch patch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateRequest(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationPatch patch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(patch, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Updates an existing migration. The request body can contain one to many of the mutable properties present in the migration definition. Certain property updates initiate migration state transitions. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="patch"> The required parameters for updating a migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/>, <paramref name="migrationName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PostgreSqlMigrationData>> UpdateAsync(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName, patch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Updates an existing migration. The request body can contain one to many of the mutable properties present in the migration definition. Certain property updates initiate migration state transitions. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="patch"> The required parameters for updating a migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/>, <paramref name="migrationName"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PostgreSqlMigrationData> Update(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, PostgreSqlMigrationPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName, patch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PostgreSqlMigrationData.DeserializePostgreSqlMigrationData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations/", false);
            uri.AppendPath(migrationName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes a migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes a migration. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationName"> The name of the migration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="targetDbServerName"/> or <paramref name="migrationName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string targetDbServerName, string migrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));
            Argument.AssertNotNullOrEmpty(migrationName, nameof(migrationName));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByTargetServerRequestUri(string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (migrationListFilter != null)
            {
                uri.AppendQuery("migrationListFilter", migrationListFilter.Value.ToString(), true);
            }
            return uri;
        }

        internal HttpMessage CreateListByTargetServerRequest(string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.DBforPostgreSQL/flexibleServers/", false);
            uri.AppendPath(targetDbServerName, true);
            uri.AppendPath("/migrations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (migrationListFilter != null)
            {
                uri.AppendQuery("migrationListFilter", migrationListFilter.Value.ToString(), true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List all the migrations on a given target server. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationListFilter"> Migration list filter. Retrieves either active migrations or all migrations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PostgreSqlMigrationResourceListResult>> ListByTargetServerAsync(string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));

            using var message = CreateListByTargetServerRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PostgreSqlMigrationResourceListResult.DeserializePostgreSqlMigrationResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all the migrations on a given target server. </summary>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationListFilter"> Migration list filter. Retrieves either active migrations or all migrations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PostgreSqlMigrationResourceListResult> ListByTargetServer(string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));

            using var message = CreateListByTargetServerRequest(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PostgreSqlMigrationResourceListResult.DeserializePostgreSqlMigrationResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByTargetServerNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListByTargetServerNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List all the migrations on a given target server. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationListFilter"> Migration list filter. Retrieves either active migrations or all migrations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<PostgreSqlMigrationResourceListResult>> ListByTargetServerNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));

            using var message = CreateListByTargetServerNextPageRequest(nextLink, subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationResourceListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PostgreSqlMigrationResourceListResult.DeserializePostgreSqlMigrationResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List all the migrations on a given target server. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID of the target database server. </param>
        /// <param name="resourceGroupName"> The resource group name of the target database server. </param>
        /// <param name="targetDbServerName"> The name of the target database server. </param>
        /// <param name="migrationListFilter"> Migration list filter. Retrieves either active migrations or all migrations. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="targetDbServerName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<PostgreSqlMigrationResourceListResult> ListByTargetServerNextPage(string nextLink, string subscriptionId, string resourceGroupName, string targetDbServerName, PostgreSqlMigrationListFilter? migrationListFilter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(targetDbServerName, nameof(targetDbServerName));

            using var message = CreateListByTargetServerNextPageRequest(nextLink, subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PostgreSqlMigrationResourceListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PostgreSqlMigrationResourceListResult.DeserializePostgreSqlMigrationResourceListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
