// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    public partial class PostgreSqlMigrationData : IUtf8JsonSerializable, IJsonModel<PostgreSqlMigrationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PostgreSqlMigrationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PostgreSqlMigrationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlMigrationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(MigrationId))
            {
                writer.WritePropertyName("migrationId"u8);
                writer.WriteStringValue(MigrationId);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentStatus))
            {
                writer.WritePropertyName("currentStatus"u8);
                writer.WriteObjectValue(CurrentStatus, options);
            }
            if (Optional.IsDefined(MigrationInstanceResourceId))
            {
                writer.WritePropertyName("migrationInstanceResourceId"u8);
                writer.WriteStringValue(MigrationInstanceResourceId);
            }
            if (Optional.IsDefined(MigrationMode))
            {
                writer.WritePropertyName("migrationMode"u8);
                writer.WriteStringValue(MigrationMode.Value.ToString());
            }
            if (Optional.IsDefined(MigrationOption))
            {
                writer.WritePropertyName("migrationOption"u8);
                writer.WriteStringValue(MigrationOption.Value.ToString());
            }
            if (Optional.IsDefined(SourceType))
            {
                writer.WritePropertyName("sourceType"u8);
                writer.WriteStringValue(SourceType.Value.ToString());
            }
            if (Optional.IsDefined(SslMode))
            {
                writer.WritePropertyName("sslMode"u8);
                writer.WriteStringValue(SslMode.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(SourceDbServerMetadata))
            {
                writer.WritePropertyName("sourceDbServerMetadata"u8);
                writer.WriteObjectValue(SourceDbServerMetadata, options);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetDbServerMetadata))
            {
                writer.WritePropertyName("targetDbServerMetadata"u8);
                writer.WriteObjectValue(TargetDbServerMetadata, options);
            }
            if (Optional.IsDefined(SourceDbServerResourceId))
            {
                writer.WritePropertyName("sourceDbServerResourceId"u8);
                writer.WriteStringValue(SourceDbServerResourceId);
            }
            if (Optional.IsDefined(SourceDbServerFullyQualifiedDomainName))
            {
                writer.WritePropertyName("sourceDbServerFullyQualifiedDomainName"u8);
                writer.WriteStringValue(SourceDbServerFullyQualifiedDomainName);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetDbServerResourceId))
            {
                writer.WritePropertyName("targetDbServerResourceId"u8);
                writer.WriteStringValue(TargetDbServerResourceId);
            }
            if (Optional.IsDefined(TargetDbServerFullyQualifiedDomainName))
            {
                writer.WritePropertyName("targetDbServerFullyQualifiedDomainName"u8);
                writer.WriteStringValue(TargetDbServerFullyQualifiedDomainName);
            }
            if (Optional.IsDefined(SecretParameters))
            {
                writer.WritePropertyName("secretParameters"u8);
                writer.WriteObjectValue(SecretParameters, options);
            }
            if (Optional.IsCollectionDefined(DbsToMigrate))
            {
                writer.WritePropertyName("dbsToMigrate"u8);
                writer.WriteStartArray();
                foreach (var item in DbsToMigrate)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SetupLogicalReplicationOnSourceDbIfNeeded))
            {
                writer.WritePropertyName("setupLogicalReplicationOnSourceDbIfNeeded"u8);
                writer.WriteStringValue(SetupLogicalReplicationOnSourceDbIfNeeded.Value.ToString());
            }
            if (Optional.IsDefined(OverwriteDbsInTarget))
            {
                writer.WritePropertyName("overwriteDbsInTarget"u8);
                writer.WriteStringValue(OverwriteDbsInTarget.Value.ToString());
            }
            if (Optional.IsDefined(MigrationWindowStartTimeInUtc))
            {
                writer.WritePropertyName("migrationWindowStartTimeInUtc"u8);
                writer.WriteStringValue(MigrationWindowStartTimeInUtc.Value, "O");
            }
            if (Optional.IsDefined(MigrationWindowEndTimeInUtc))
            {
                writer.WritePropertyName("migrationWindowEndTimeInUtc"u8);
                writer.WriteStringValue(MigrationWindowEndTimeInUtc.Value, "O");
            }
            if (Optional.IsDefined(MigrateRoles))
            {
                writer.WritePropertyName("migrateRoles"u8);
                writer.WriteStringValue(MigrateRoles.Value.ToString());
            }
            if (Optional.IsDefined(StartDataMigration))
            {
                writer.WritePropertyName("startDataMigration"u8);
                writer.WriteStringValue(StartDataMigration.Value.ToString());
            }
            if (Optional.IsDefined(TriggerCutover))
            {
                writer.WritePropertyName("triggerCutover"u8);
                writer.WriteStringValue(TriggerCutover.Value.ToString());
            }
            if (Optional.IsCollectionDefined(DbsToTriggerCutoverOn))
            {
                writer.WritePropertyName("dbsToTriggerCutoverOn"u8);
                writer.WriteStartArray();
                foreach (var item in DbsToTriggerCutoverOn)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Cancel))
            {
                writer.WritePropertyName("cancel"u8);
                writer.WriteStringValue(Cancel.Value.ToString());
            }
            if (Optional.IsCollectionDefined(DbsToCancelMigrationOn))
            {
                writer.WritePropertyName("dbsToCancelMigrationOn"u8);
                writer.WriteStartArray();
                foreach (var item in DbsToCancelMigrationOn)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        PostgreSqlMigrationData IJsonModel<PostgreSqlMigrationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlMigrationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePostgreSqlMigrationData(document.RootElement, options);
        }

        internal static PostgreSqlMigrationData DeserializePostgreSqlMigrationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string migrationId = default;
            PostgreSqlMigrationStatus currentStatus = default;
            ResourceIdentifier migrationInstanceResourceId = default;
            PostgreSqlMigrationMode? migrationMode = default;
            MigrationOption? migrationOption = default;
            PostgreSqlFlexibleServersSourceType? sourceType = default;
            PostgreSqlFlexibleServersSslMode? sslMode = default;
            PostgreSqlServerMetadata sourceDbServerMetadata = default;
            PostgreSqlServerMetadata targetDbServerMetadata = default;
            ResourceIdentifier sourceDbServerResourceId = default;
            string sourceDbServerFullyQualifiedDomainName = default;
            ResourceIdentifier targetDbServerResourceId = default;
            string targetDbServerFullyQualifiedDomainName = default;
            PostgreSqlMigrationSecretParameters secretParameters = default;
            IList<string> dbsToMigrate = default;
            PostgreSqlMigrationLogicalReplicationOnSourceDb? setupLogicalReplicationOnSourceDbIfNeeded = default;
            PostgreSqlMigrationOverwriteDbsInTarget? overwriteDbsInTarget = default;
            DateTimeOffset? migrationWindowStartTimeInUtc = default;
            DateTimeOffset? migrationWindowEndTimeInUtc = default;
            MigrateRolesEnum? migrateRoles = default;
            PostgreSqlMigrationStartDataMigration? startDataMigration = default;
            PostgreSqlMigrationTriggerCutover? triggerCutover = default;
            IList<string> dbsToTriggerCutoverOn = default;
            PostgreSqlMigrationCancel? cancel = default;
            IList<string> dbsToCancelMigrationOn = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("migrationId"u8))
                        {
                            migrationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currentStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            currentStatus = PostgreSqlMigrationStatus.DeserializePostgreSqlMigrationStatus(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("migrationInstanceResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationInstanceResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("migrationMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationMode = new PostgreSqlMigrationMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("migrationOption"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationOption = new MigrationOption(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sourceType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sourceType = new PostgreSqlFlexibleServersSourceType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sslMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sslMode = new PostgreSqlFlexibleServersSslMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sourceDbServerMetadata"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sourceDbServerMetadata = PostgreSqlServerMetadata.DeserializePostgreSqlServerMetadata(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("targetDbServerMetadata"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            targetDbServerMetadata = PostgreSqlServerMetadata.DeserializePostgreSqlServerMetadata(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("sourceDbServerResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sourceDbServerResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sourceDbServerFullyQualifiedDomainName"u8))
                        {
                            sourceDbServerFullyQualifiedDomainName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("targetDbServerResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            targetDbServerResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("targetDbServerFullyQualifiedDomainName"u8))
                        {
                            targetDbServerFullyQualifiedDomainName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("secretParameters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            secretParameters = PostgreSqlMigrationSecretParameters.DeserializePostgreSqlMigrationSecretParameters(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("dbsToMigrate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            dbsToMigrate = array;
                            continue;
                        }
                        if (property0.NameEquals("setupLogicalReplicationOnSourceDbIfNeeded"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            setupLogicalReplicationOnSourceDbIfNeeded = new PostgreSqlMigrationLogicalReplicationOnSourceDb(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("overwriteDbsInTarget"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            overwriteDbsInTarget = new PostgreSqlMigrationOverwriteDbsInTarget(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("migrationWindowStartTimeInUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationWindowStartTimeInUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("migrationWindowEndTimeInUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrationWindowEndTimeInUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("migrateRoles"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            migrateRoles = new MigrateRolesEnum(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startDataMigration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startDataMigration = new PostgreSqlMigrationStartDataMigration(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("triggerCutover"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            triggerCutover = new PostgreSqlMigrationTriggerCutover(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dbsToTriggerCutoverOn"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            dbsToTriggerCutoverOn = array;
                            continue;
                        }
                        if (property0.NameEquals("cancel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            cancel = new PostgreSqlMigrationCancel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("dbsToCancelMigrationOn"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            dbsToCancelMigrationOn = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PostgreSqlMigrationData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                migrationId,
                currentStatus,
                migrationInstanceResourceId,
                migrationMode,
                migrationOption,
                sourceType,
                sslMode,
                sourceDbServerMetadata,
                targetDbServerMetadata,
                sourceDbServerResourceId,
                sourceDbServerFullyQualifiedDomainName,
                targetDbServerResourceId,
                targetDbServerFullyQualifiedDomainName,
                secretParameters,
                dbsToMigrate ?? new ChangeTrackingList<string>(),
                setupLogicalReplicationOnSourceDbIfNeeded,
                overwriteDbsInTarget,
                migrationWindowStartTimeInUtc,
                migrationWindowEndTimeInUtc,
                migrateRoles,
                startDataMigration,
                triggerCutover,
                dbsToTriggerCutoverOn ?? new ChangeTrackingList<string>(),
                cancel,
                dbsToCancelMigrationOn ?? new ChangeTrackingList<string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationId))
                {
                    builder.Append("    migrationId: ");
                    if (MigrationId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{MigrationId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{MigrationId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CurrentStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    currentStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CurrentStatus))
                {
                    builder.Append("    currentStatus: ");
                    BicepSerializationHelpers.AppendChildObject(builder, CurrentStatus, options, 4, false, "    currentStatus: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationInstanceResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationInstanceResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationInstanceResourceId))
                {
                    builder.Append("    migrationInstanceResourceId: ");
                    builder.AppendLine($"'{MigrationInstanceResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationMode))
                {
                    builder.Append("    migrationMode: ");
                    builder.AppendLine($"'{MigrationMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationOption), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationOption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationOption))
                {
                    builder.Append("    migrationOption: ");
                    builder.AppendLine($"'{MigrationOption.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceType))
                {
                    builder.Append("    sourceType: ");
                    builder.AppendLine($"'{SourceType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SslMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sslMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SslMode))
                {
                    builder.Append("    sslMode: ");
                    builder.AppendLine($"'{SslMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceDbServerMetadata), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceDbServerMetadata: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceDbServerMetadata))
                {
                    builder.Append("    sourceDbServerMetadata: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SourceDbServerMetadata, options, 4, false, "    sourceDbServerMetadata: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetDbServerMetadata), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    targetDbServerMetadata: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetDbServerMetadata))
                {
                    builder.Append("    targetDbServerMetadata: ");
                    BicepSerializationHelpers.AppendChildObject(builder, TargetDbServerMetadata, options, 4, false, "    targetDbServerMetadata: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceDbServerResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceDbServerResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceDbServerResourceId))
                {
                    builder.Append("    sourceDbServerResourceId: ");
                    builder.AppendLine($"'{SourceDbServerResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceDbServerFullyQualifiedDomainName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sourceDbServerFullyQualifiedDomainName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceDbServerFullyQualifiedDomainName))
                {
                    builder.Append("    sourceDbServerFullyQualifiedDomainName: ");
                    if (SourceDbServerFullyQualifiedDomainName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceDbServerFullyQualifiedDomainName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceDbServerFullyQualifiedDomainName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetDbServerResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    targetDbServerResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetDbServerResourceId))
                {
                    builder.Append("    targetDbServerResourceId: ");
                    builder.AppendLine($"'{TargetDbServerResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetDbServerFullyQualifiedDomainName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    targetDbServerFullyQualifiedDomainName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetDbServerFullyQualifiedDomainName))
                {
                    builder.Append("    targetDbServerFullyQualifiedDomainName: ");
                    if (TargetDbServerFullyQualifiedDomainName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TargetDbServerFullyQualifiedDomainName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TargetDbServerFullyQualifiedDomainName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecretParameters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    secretParameters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecretParameters))
                {
                    builder.Append("    secretParameters: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SecretParameters, options, 4, false, "    secretParameters: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DbsToMigrate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dbsToMigrate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DbsToMigrate))
                {
                    if (DbsToMigrate.Any())
                    {
                        builder.Append("    dbsToMigrate: ");
                        builder.AppendLine("[");
                        foreach (var item in DbsToMigrate)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SetupLogicalReplicationOnSourceDbIfNeeded), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    setupLogicalReplicationOnSourceDbIfNeeded: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SetupLogicalReplicationOnSourceDbIfNeeded))
                {
                    builder.Append("    setupLogicalReplicationOnSourceDbIfNeeded: ");
                    builder.AppendLine($"'{SetupLogicalReplicationOnSourceDbIfNeeded.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OverwriteDbsInTarget), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    overwriteDbsInTarget: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OverwriteDbsInTarget))
                {
                    builder.Append("    overwriteDbsInTarget: ");
                    builder.AppendLine($"'{OverwriteDbsInTarget.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationWindowStartTimeInUtc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationWindowStartTimeInUtc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationWindowStartTimeInUtc))
                {
                    builder.Append("    migrationWindowStartTimeInUtc: ");
                    var formattedDateTimeString = TypeFormatters.ToString(MigrationWindowStartTimeInUtc.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrationWindowEndTimeInUtc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrationWindowEndTimeInUtc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrationWindowEndTimeInUtc))
                {
                    builder.Append("    migrationWindowEndTimeInUtc: ");
                    var formattedDateTimeString = TypeFormatters.ToString(MigrationWindowEndTimeInUtc.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MigrateRoles), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    migrateRoles: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MigrateRoles))
                {
                    builder.Append("    migrateRoles: ");
                    builder.AppendLine($"'{MigrateRoles.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StartDataMigration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    startDataMigration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StartDataMigration))
                {
                    builder.Append("    startDataMigration: ");
                    builder.AppendLine($"'{StartDataMigration.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TriggerCutover), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    triggerCutover: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TriggerCutover))
                {
                    builder.Append("    triggerCutover: ");
                    builder.AppendLine($"'{TriggerCutover.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DbsToTriggerCutoverOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dbsToTriggerCutoverOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DbsToTriggerCutoverOn))
                {
                    if (DbsToTriggerCutoverOn.Any())
                    {
                        builder.Append("    dbsToTriggerCutoverOn: ");
                        builder.AppendLine("[");
                        foreach (var item in DbsToTriggerCutoverOn)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Cancel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    cancel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Cancel))
                {
                    builder.Append("    cancel: ");
                    builder.AppendLine($"'{Cancel.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DbsToCancelMigrationOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dbsToCancelMigrationOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DbsToCancelMigrationOn))
                {
                    if (DbsToCancelMigrationOn.Any())
                    {
                        builder.Append("    dbsToCancelMigrationOn: ");
                        builder.AppendLine("[");
                        foreach (var item in DbsToCancelMigrationOn)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PostgreSqlMigrationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlMigrationData)} does not support writing '{options.Format}' format.");
            }
        }

        PostgreSqlMigrationData IPersistableModel<PostgreSqlMigrationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePostgreSqlMigrationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlMigrationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PostgreSqlMigrationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
