// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    /// <summary>
    /// A class representing the PostgreSqlFlexibleServer data model.
    /// Represents a server.
    /// </summary>
    public partial class PostgreSqlFlexibleServerData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerData"/>. </summary>
        /// <param name="location"> The location. </param>
        public PostgreSqlFlexibleServerData(AzureLocation location) : base(location)
        {
            PrivateEndpointConnections = new ChangeTrackingList<PostgreSqlFlexibleServersPrivateEndpointConnectionData>();
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The SKU (pricing tier) of the server. </param>
        /// <param name="identity"> Describes the identity of the application. </param>
        /// <param name="administratorLogin"> The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation). </param>
        /// <param name="administratorLoginPassword"> The administrator login password (required for server creation). </param>
        /// <param name="version"> PostgreSQL Server version. </param>
        /// <param name="minorVersion"> The minor version of the server. </param>
        /// <param name="state"> A state of a server that is visible to user. </param>
        /// <param name="fullyQualifiedDomainName"> The fully qualified domain name of a server. </param>
        /// <param name="storage"> Storage properties of a server. </param>
        /// <param name="authConfig"> AuthConfig properties of a server. </param>
        /// <param name="dataEncryption"> Data encryption properties of a server. </param>
        /// <param name="backup"> Backup properties of a server. </param>
        /// <param name="network"> Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server. </param>
        /// <param name="highAvailability"> High availability properties of a server. </param>
        /// <param name="maintenanceWindow"> Maintenance window properties of a server. </param>
        /// <param name="sourceServerResourceId"> The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned only for Replica server. </param>
        /// <param name="pointInTimeUtc"> Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'. </param>
        /// <param name="availabilityZone"> availability zone information of the server. </param>
        /// <param name="replicationRole"> Replication role of the server. </param>
        /// <param name="replicaCapacity"> Replicas allowed for a server. </param>
        /// <param name="replica"> Replica properties of a server. These Replica properties are required to be passed only in case you want to Promote a server. </param>
        /// <param name="createMode"> The mode to create a new PostgreSQL server. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections associated with the specified resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlFlexibleServerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, PostgreSqlFlexibleServerSku sku, PostgreSqlFlexibleServerUserAssignedIdentity identity, string administratorLogin, string administratorLoginPassword, PostgreSqlFlexibleServerVersion? version, string minorVersion, PostgreSqlFlexibleServerState? state, string fullyQualifiedDomainName, PostgreSqlFlexibleServerStorage storage, PostgreSqlFlexibleServerAuthConfig authConfig, PostgreSqlFlexibleServerDataEncryption dataEncryption, PostgreSqlFlexibleServerBackupProperties backup, PostgreSqlFlexibleServerNetwork network, PostgreSqlFlexibleServerHighAvailability highAvailability, PostgreSqlFlexibleServerMaintenanceWindow maintenanceWindow, ResourceIdentifier sourceServerResourceId, DateTimeOffset? pointInTimeUtc, string availabilityZone, PostgreSqlFlexibleServerReplicationRole? replicationRole, int? replicaCapacity, PostgreSqlFlexibleServersReplica replica, PostgreSqlFlexibleServerCreateMode? createMode, IReadOnlyList<PostgreSqlFlexibleServersPrivateEndpointConnectionData> privateEndpointConnections, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            Identity = identity;
            AdministratorLogin = administratorLogin;
            AdministratorLoginPassword = administratorLoginPassword;
            Version = version;
            MinorVersion = minorVersion;
            State = state;
            FullyQualifiedDomainName = fullyQualifiedDomainName;
            Storage = storage;
            AuthConfig = authConfig;
            DataEncryption = dataEncryption;
            Backup = backup;
            Network = network;
            HighAvailability = highAvailability;
            MaintenanceWindow = maintenanceWindow;
            SourceServerResourceId = sourceServerResourceId;
            PointInTimeUtc = pointInTimeUtc;
            AvailabilityZone = availabilityZone;
            ReplicationRole = replicationRole;
            ReplicaCapacity = replicaCapacity;
            Replica = replica;
            CreateMode = createMode;
            PrivateEndpointConnections = privateEndpointConnections;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerData"/> for deserialization. </summary>
        internal PostgreSqlFlexibleServerData()
        {
        }

        /// <summary> The SKU (pricing tier) of the server. </summary>
        [WirePath("sku")]
        public PostgreSqlFlexibleServerSku Sku { get; set; }
        /// <summary> Describes the identity of the application. </summary>
        [WirePath("identity")]
        public PostgreSqlFlexibleServerUserAssignedIdentity Identity { get; set; }
        /// <summary> The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation). </summary>
        [WirePath("properties.administratorLogin")]
        public string AdministratorLogin { get; set; }
        /// <summary> The administrator login password (required for server creation). </summary>
        [WirePath("properties.administratorLoginPassword")]
        public string AdministratorLoginPassword { get; set; }
        /// <summary> PostgreSQL Server version. </summary>
        [WirePath("properties.version")]
        public PostgreSqlFlexibleServerVersion? Version { get; set; }
        /// <summary> The minor version of the server. </summary>
        [WirePath("properties.minorVersion")]
        public string MinorVersion { get; }
        /// <summary> A state of a server that is visible to user. </summary>
        [WirePath("properties.state")]
        public PostgreSqlFlexibleServerState? State { get; }
        /// <summary> The fully qualified domain name of a server. </summary>
        [WirePath("properties.fullyQualifiedDomainName")]
        public string FullyQualifiedDomainName { get; }
        /// <summary> Storage properties of a server. </summary>
        [WirePath("properties.storage")]
        public PostgreSqlFlexibleServerStorage Storage { get; set; }
        /// <summary> AuthConfig properties of a server. </summary>
        [WirePath("properties.authConfig")]
        public PostgreSqlFlexibleServerAuthConfig AuthConfig { get; set; }
        /// <summary> Data encryption properties of a server. </summary>
        [WirePath("properties.dataEncryption")]
        public PostgreSqlFlexibleServerDataEncryption DataEncryption { get; set; }
        /// <summary> Backup properties of a server. </summary>
        [WirePath("properties.backup")]
        public PostgreSqlFlexibleServerBackupProperties Backup { get; set; }
        /// <summary> Network properties of a server. This Network property is required to be passed only in case you want the server to be Private access server. </summary>
        [WirePath("properties.network")]
        public PostgreSqlFlexibleServerNetwork Network { get; set; }
        /// <summary> High availability properties of a server. </summary>
        [WirePath("properties.highAvailability")]
        public PostgreSqlFlexibleServerHighAvailability HighAvailability { get; set; }
        /// <summary> Maintenance window properties of a server. </summary>
        [WirePath("properties.maintenanceWindow")]
        public PostgreSqlFlexibleServerMaintenanceWindow MaintenanceWindow { get; set; }
        /// <summary> The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned only for Replica server. </summary>
        [WirePath("properties.sourceServerResourceId")]
        public ResourceIdentifier SourceServerResourceId { get; set; }
        /// <summary> Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'. </summary>
        [WirePath("properties.pointInTimeUTC")]
        public DateTimeOffset? PointInTimeUtc { get; set; }
        /// <summary> availability zone information of the server. </summary>
        [WirePath("properties.availabilityZone")]
        public string AvailabilityZone { get; set; }
        /// <summary> Replication role of the server. </summary>
        [WirePath("properties.replicationRole")]
        public PostgreSqlFlexibleServerReplicationRole? ReplicationRole { get; set; }
        /// <summary> Replica properties of a server. These Replica properties are required to be passed only in case you want to Promote a server. </summary>
        [WirePath("properties.replica")]
        public PostgreSqlFlexibleServersReplica Replica { get; set; }
        /// <summary> The mode to create a new PostgreSQL server. </summary>
        [WirePath("properties.createMode")]
        public PostgreSqlFlexibleServerCreateMode? CreateMode { get; set; }
        /// <summary> List of private endpoint connections associated with the specified resource. </summary>
        [WirePath("properties.privateEndpointConnections")]
        public IReadOnlyList<PostgreSqlFlexibleServersPrivateEndpointConnectionData> PrivateEndpointConnections { get; }
    }
}
