// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.PostgreSql.FlexibleServers.Models;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers
{
    /// <summary>
    /// A class representing the PostgreSqlFlexibleServerConfiguration data model.
    /// Represents a Configuration.
    /// </summary>
    public partial class PostgreSqlFlexibleServerConfigurationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerConfigurationData"/>. </summary>
        public PostgreSqlFlexibleServerConfigurationData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="value"> Value of the configuration. Required to update the configuration. </param>
        /// <param name="description"> Description of the configuration. </param>
        /// <param name="defaultValue"> Default value of the configuration. </param>
        /// <param name="dataType"> Data type of the configuration. </param>
        /// <param name="allowedValues"> Allowed values of the configuration. </param>
        /// <param name="source"> Source of the configuration. Required to update the configuration. </param>
        /// <param name="isDynamicConfig"> Configuration dynamic or static. </param>
        /// <param name="isReadOnly"> Configuration read-only or not. </param>
        /// <param name="isConfigPendingRestart"> Configuration is pending restart or not. </param>
        /// <param name="unit"> Configuration unit. </param>
        /// <param name="documentationLink"> Configuration documentation link. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlFlexibleServerConfigurationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string value, string description, string defaultValue, PostgreSqlFlexibleServerConfigurationDataType? dataType, string allowedValues, string source, bool? isDynamicConfig, bool? isReadOnly, bool? isConfigPendingRestart, string unit, string documentationLink, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Value = value;
            Description = description;
            DefaultValue = defaultValue;
            DataType = dataType;
            AllowedValues = allowedValues;
            Source = source;
            IsDynamicConfig = isDynamicConfig;
            IsReadOnly = isReadOnly;
            IsConfigPendingRestart = isConfigPendingRestart;
            Unit = unit;
            DocumentationLink = documentationLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Value of the configuration. Required to update the configuration. </summary>
        [WirePath("properties.value")]
        public string Value { get; set; }
        /// <summary> Description of the configuration. </summary>
        [WirePath("properties.description")]
        public string Description { get; }
        /// <summary> Default value of the configuration. </summary>
        [WirePath("properties.defaultValue")]
        public string DefaultValue { get; }
        /// <summary> Data type of the configuration. </summary>
        [WirePath("properties.dataType")]
        public PostgreSqlFlexibleServerConfigurationDataType? DataType { get; }
        /// <summary> Allowed values of the configuration. </summary>
        [WirePath("properties.allowedValues")]
        public string AllowedValues { get; }
        /// <summary> Source of the configuration. Required to update the configuration. </summary>
        [WirePath("properties.source")]
        public string Source { get; set; }
        /// <summary> Configuration dynamic or static. </summary>
        [WirePath("properties.isDynamicConfig")]
        public bool? IsDynamicConfig { get; }
        /// <summary> Configuration read-only or not. </summary>
        [WirePath("properties.isReadOnly")]
        public bool? IsReadOnly { get; }
        /// <summary> Configuration is pending restart or not. </summary>
        [WirePath("properties.isConfigPendingRestart")]
        public bool? IsConfigPendingRestart { get; }
        /// <summary> Configuration unit. </summary>
        [WirePath("properties.unit")]
        public string Unit { get; }
        /// <summary> Configuration documentation link. </summary>
        [WirePath("properties.documentationLink")]
        public string DocumentationLink { get; }
    }
}
