// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> The endpoint type for the virtual endpoint. </summary>
    public readonly partial struct VirtualEndpointType : IEquatable<VirtualEndpointType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VirtualEndpointType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VirtualEndpointType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadWriteValue = "ReadWrite";

        /// <summary> ReadWrite. </summary>
        public static VirtualEndpointType ReadWrite { get; } = new VirtualEndpointType(ReadWriteValue);
        /// <summary> Determines if two <see cref="VirtualEndpointType"/> values are the same. </summary>
        public static bool operator ==(VirtualEndpointType left, VirtualEndpointType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VirtualEndpointType"/> values are not the same. </summary>
        public static bool operator !=(VirtualEndpointType left, VirtualEndpointType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VirtualEndpointType"/>. </summary>
        public static implicit operator VirtualEndpointType(string value) => new VirtualEndpointType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VirtualEndpointType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VirtualEndpointType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
