// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Validation summary object. </summary>
    public partial class ValidationSummaryItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ValidationSummaryItem"/>. </summary>
        internal ValidationSummaryItem()
        {
            Messages = new ChangeTrackingList<PostgreSqlFlexibleServersValidationMessage>();
        }

        /// <summary> Initializes a new instance of <see cref="ValidationSummaryItem"/>. </summary>
        /// <param name="validationSummaryItemType"> Validation type. </param>
        /// <param name="state"> Validation status for migration. </param>
        /// <param name="messages"> Validation messages. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ValidationSummaryItem(string validationSummaryItemType, PostgreSqlFlexibleServersValidationState? state, IReadOnlyList<PostgreSqlFlexibleServersValidationMessage> messages, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ValidationSummaryItemType = validationSummaryItemType;
            State = state;
            Messages = messages;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Validation type. </summary>
        [WirePath("type")]
        public string ValidationSummaryItemType { get; }
        /// <summary> Validation status for migration. </summary>
        [WirePath("state")]
        public PostgreSqlFlexibleServersValidationState? State { get; }
        /// <summary> Validation messages. </summary>
        [WirePath("messages")]
        public IReadOnlyList<PostgreSqlFlexibleServersValidationMessage> Messages { get; }
    }
}
