// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    internal static partial class ThreatProtectionStateExtensions
    {
        public static string ToSerialString(this ThreatProtectionState value) => value switch
        {
            ThreatProtectionState.Enabled => "Enabled",
            ThreatProtectionState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ThreatProtectionState value.")
        };

        public static ThreatProtectionState ToThreatProtectionState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return ThreatProtectionState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return ThreatProtectionState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ThreatProtectionState value.");
        }
    }
}
