// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Sets the promote options for a replica server. This is a write only property. </summary>
    public readonly partial struct ReplicationPromoteOption : IEquatable<ReplicationPromoteOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReplicationPromoteOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReplicationPromoteOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PlannedValue = "planned";
        private const string ForcedValue = "forced";

        /// <summary> planned. </summary>
        public static ReplicationPromoteOption Planned { get; } = new ReplicationPromoteOption(PlannedValue);
        /// <summary> forced. </summary>
        public static ReplicationPromoteOption Forced { get; } = new ReplicationPromoteOption(ForcedValue);
        /// <summary> Determines if two <see cref="ReplicationPromoteOption"/> values are the same. </summary>
        public static bool operator ==(ReplicationPromoteOption left, ReplicationPromoteOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReplicationPromoteOption"/> values are not the same. </summary>
        public static bool operator !=(ReplicationPromoteOption left, ReplicationPromoteOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReplicationPromoteOption"/>. </summary>
        public static implicit operator ReplicationPromoteOption(string value) => new ReplicationPromoteOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReplicationPromoteOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReplicationPromoteOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
