// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Database server metadata. </summary>
    public partial class PostgreSqlServerMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlServerMetadata"/>. </summary>
        internal PostgreSqlServerMetadata()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlServerMetadata"/>. </summary>
        /// <param name="location"> Location of database server. </param>
        /// <param name="version"> Version for database engine. </param>
        /// <param name="storageMb"> Storage size in MB for database server. </param>
        /// <param name="sku"> SKU for the database server. This object is empty for PG single server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlServerMetadata(AzureLocation? location, string version, int? storageMb, PostgreSqlFlexibleServersServerSku sku, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            Version = version;
            StorageMb = storageMb;
            Sku = sku;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Location of database server. </summary>
        [WirePath("location")]
        public AzureLocation? Location { get; }
        /// <summary> Version for database engine. </summary>
        [WirePath("version")]
        public string Version { get; }
        /// <summary> Storage size in MB for database server. </summary>
        [WirePath("storageMb")]
        public int? StorageMb { get; }
        /// <summary> SKU for the database server. This object is empty for PG single server. </summary>
        [WirePath("sku")]
        public PostgreSqlFlexibleServersServerSku Sku { get; }
    }
}
