// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> To trigger cutover for entire migration we need to send this flag as True. </summary>
    public readonly partial struct PostgreSqlMigrationTriggerCutover : IEquatable<PostgreSqlMigrationTriggerCutover>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationTriggerCutover"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlMigrationTriggerCutover(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static PostgreSqlMigrationTriggerCutover True { get; } = new PostgreSqlMigrationTriggerCutover(TrueValue);
        /// <summary> False. </summary>
        public static PostgreSqlMigrationTriggerCutover False { get; } = new PostgreSqlMigrationTriggerCutover(FalseValue);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationTriggerCutover"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlMigrationTriggerCutover left, PostgreSqlMigrationTriggerCutover right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationTriggerCutover"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlMigrationTriggerCutover left, PostgreSqlMigrationTriggerCutover right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlMigrationTriggerCutover"/>. </summary>
        public static implicit operator PostgreSqlMigrationTriggerCutover(string value) => new PostgreSqlMigrationTriggerCutover(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlMigrationTriggerCutover other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlMigrationTriggerCutover other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
