// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Migration sub state details. </summary>
    public partial class PostgreSqlMigrationSubStateDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationSubStateDetails"/>. </summary>
        internal PostgreSqlMigrationSubStateDetails()
        {
            DbDetails = new ChangeTrackingDictionary<string, DbMigrationStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationSubStateDetails"/>. </summary>
        /// <param name="currentSubState"> Migration sub state. </param>
        /// <param name="dbDetails"> Dictionary of &lt;DbMigrationStatus&gt;. </param>
        /// <param name="validationDetails"> Details for the validation for migration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlMigrationSubStateDetails(PostgreSqlMigrationSubState? currentSubState, IReadOnlyDictionary<string, DbMigrationStatus> dbDetails, PostgreSqlFlexibleServersValidationDetails validationDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentSubState = currentSubState;
            DbDetails = dbDetails;
            ValidationDetails = validationDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Migration sub state. </summary>
        [WirePath("currentSubState")]
        public PostgreSqlMigrationSubState? CurrentSubState { get; }
        /// <summary> Dictionary of &lt;DbMigrationStatus&gt;. </summary>
        [WirePath("dbDetails")]
        public IReadOnlyDictionary<string, DbMigrationStatus> DbDetails { get; }
        /// <summary> Details for the validation for migration. </summary>
        [WirePath("validationDetails")]
        public PostgreSqlFlexibleServersValidationDetails ValidationDetails { get; }
    }
}
