// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Migration sub state. </summary>
    public readonly partial struct PostgreSqlMigrationSubState : IEquatable<PostgreSqlMigrationSubState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationSubState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlMigrationSubState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PerformingPreRequisiteStepsValue = "PerformingPreRequisiteSteps";
        private const string WaitingForLogicalReplicationSetupRequestOnSourceDBValue = "WaitingForLogicalReplicationSetupRequestOnSourceDB";
        private const string WaitingForDBsToMigrateSpecificationValue = "WaitingForDBsToMigrateSpecification";
        private const string WaitingForTargetDBOverwriteConfirmationValue = "WaitingForTargetDBOverwriteConfirmation";
        private const string WaitingForDataMigrationSchedulingValue = "WaitingForDataMigrationScheduling";
        private const string WaitingForDataMigrationWindowValue = "WaitingForDataMigrationWindow";
        private const string MigratingDataValue = "MigratingData";
        private const string WaitingForCutoverTriggerValue = "WaitingForCutoverTrigger";
        private const string CompletingMigrationValue = "CompletingMigration";
        private const string CompletedValue = "Completed";
        private const string CancelingRequestedDBMigrationsValue = "CancelingRequestedDBMigrations";
        private const string ValidationInProgressValue = "ValidationInProgress";

        /// <summary> PerformingPreRequisiteSteps. </summary>
        public static PostgreSqlMigrationSubState PerformingPreRequisiteSteps { get; } = new PostgreSqlMigrationSubState(PerformingPreRequisiteStepsValue);
        /// <summary> WaitingForLogicalReplicationSetupRequestOnSourceDB. </summary>
        public static PostgreSqlMigrationSubState WaitingForLogicalReplicationSetupRequestOnSourceDB { get; } = new PostgreSqlMigrationSubState(WaitingForLogicalReplicationSetupRequestOnSourceDBValue);
        /// <summary> WaitingForDBsToMigrateSpecification. </summary>
        public static PostgreSqlMigrationSubState WaitingForDBsToMigrateSpecification { get; } = new PostgreSqlMigrationSubState(WaitingForDBsToMigrateSpecificationValue);
        /// <summary> WaitingForTargetDBOverwriteConfirmation. </summary>
        public static PostgreSqlMigrationSubState WaitingForTargetDBOverwriteConfirmation { get; } = new PostgreSqlMigrationSubState(WaitingForTargetDBOverwriteConfirmationValue);
        /// <summary> WaitingForDataMigrationScheduling. </summary>
        public static PostgreSqlMigrationSubState WaitingForDataMigrationScheduling { get; } = new PostgreSqlMigrationSubState(WaitingForDataMigrationSchedulingValue);
        /// <summary> WaitingForDataMigrationWindow. </summary>
        public static PostgreSqlMigrationSubState WaitingForDataMigrationWindow { get; } = new PostgreSqlMigrationSubState(WaitingForDataMigrationWindowValue);
        /// <summary> MigratingData. </summary>
        public static PostgreSqlMigrationSubState MigratingData { get; } = new PostgreSqlMigrationSubState(MigratingDataValue);
        /// <summary> WaitingForCutoverTrigger. </summary>
        public static PostgreSqlMigrationSubState WaitingForCutoverTrigger { get; } = new PostgreSqlMigrationSubState(WaitingForCutoverTriggerValue);
        /// <summary> CompletingMigration. </summary>
        public static PostgreSqlMigrationSubState CompletingMigration { get; } = new PostgreSqlMigrationSubState(CompletingMigrationValue);
        /// <summary> Completed. </summary>
        public static PostgreSqlMigrationSubState Completed { get; } = new PostgreSqlMigrationSubState(CompletedValue);
        /// <summary> CancelingRequestedDBMigrations. </summary>
        public static PostgreSqlMigrationSubState CancelingRequestedDBMigrations { get; } = new PostgreSqlMigrationSubState(CancelingRequestedDBMigrationsValue);
        /// <summary> ValidationInProgress. </summary>
        public static PostgreSqlMigrationSubState ValidationInProgress { get; } = new PostgreSqlMigrationSubState(ValidationInProgressValue);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationSubState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlMigrationSubState left, PostgreSqlMigrationSubState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationSubState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlMigrationSubState left, PostgreSqlMigrationSubState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlMigrationSubState"/>. </summary>
        public static implicit operator PostgreSqlMigrationSubState(string value) => new PostgreSqlMigrationSubState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlMigrationSubState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlMigrationSubState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
