// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Indicates whether the data migration should start right away. </summary>
    public readonly partial struct PostgreSqlMigrationStartDataMigration : IEquatable<PostgreSqlMigrationStartDataMigration>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationStartDataMigration"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlMigrationStartDataMigration(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static PostgreSqlMigrationStartDataMigration True { get; } = new PostgreSqlMigrationStartDataMigration(TrueValue);
        /// <summary> False. </summary>
        public static PostgreSqlMigrationStartDataMigration False { get; } = new PostgreSqlMigrationStartDataMigration(FalseValue);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationStartDataMigration"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlMigrationStartDataMigration left, PostgreSqlMigrationStartDataMigration right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationStartDataMigration"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlMigrationStartDataMigration left, PostgreSqlMigrationStartDataMigration right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlMigrationStartDataMigration"/>. </summary>
        public static implicit operator PostgreSqlMigrationStartDataMigration(string value) => new PostgreSqlMigrationStartDataMigration(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlMigrationStartDataMigration other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlMigrationStartDataMigration other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
