// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    public partial class PostgreSqlMigrationSecretParameters : IUtf8JsonSerializable, IJsonModel<PostgreSqlMigrationSecretParameters>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PostgreSqlMigrationSecretParameters>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PostgreSqlMigrationSecretParameters>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationSecretParameters>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlMigrationSecretParameters)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("adminCredentials"u8);
            writer.WriteObjectValue(AdminCredentials, options);
            if (Optional.IsDefined(SourceServerUsername))
            {
                writer.WritePropertyName("sourceServerUsername"u8);
                writer.WriteStringValue(SourceServerUsername);
            }
            if (Optional.IsDefined(TargetServerUsername))
            {
                writer.WritePropertyName("targetServerUsername"u8);
                writer.WriteStringValue(TargetServerUsername);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PostgreSqlMigrationSecretParameters IJsonModel<PostgreSqlMigrationSecretParameters>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationSecretParameters>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlMigrationSecretParameters)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePostgreSqlMigrationSecretParameters(document.RootElement, options);
        }

        internal static PostgreSqlMigrationSecretParameters DeserializePostgreSqlMigrationSecretParameters(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PostgreSqlMigrationAdminCredentials adminCredentials = default;
            string sourceServerUsername = default;
            string targetServerUsername = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("adminCredentials"u8))
                {
                    adminCredentials = PostgreSqlMigrationAdminCredentials.DeserializePostgreSqlMigrationAdminCredentials(property.Value, options);
                    continue;
                }
                if (property.NameEquals("sourceServerUsername"u8))
                {
                    sourceServerUsername = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("targetServerUsername"u8))
                {
                    targetServerUsername = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PostgreSqlMigrationSecretParameters(adminCredentials, sourceServerUsername, targetServerUsername, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdminCredentials), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  adminCredentials: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdminCredentials))
                {
                    builder.Append("  adminCredentials: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AdminCredentials, options, 2, false, "  adminCredentials: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SourceServerUsername), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sourceServerUsername: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SourceServerUsername))
                {
                    builder.Append("  sourceServerUsername: ");
                    if (SourceServerUsername.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SourceServerUsername}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SourceServerUsername}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetServerUsername), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  targetServerUsername: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetServerUsername))
                {
                    builder.Append("  targetServerUsername: ");
                    if (TargetServerUsername.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TargetServerUsername}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TargetServerUsername}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PostgreSqlMigrationSecretParameters>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationSecretParameters>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlMigrationSecretParameters)} does not support writing '{options.Format}' format.");
            }
        }

        PostgreSqlMigrationSecretParameters IPersistableModel<PostgreSqlMigrationSecretParameters>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlMigrationSecretParameters>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePostgreSqlMigrationSecretParameters(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlMigrationSecretParameters)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PostgreSqlMigrationSecretParameters>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
