// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> There are two types of migration modes Online and Offline. </summary>
    public readonly partial struct PostgreSqlMigrationMode : IEquatable<PostgreSqlMigrationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlMigrationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OfflineValue = "Offline";
        private const string OnlineValue = "Online";

        /// <summary> Offline. </summary>
        public static PostgreSqlMigrationMode Offline { get; } = new PostgreSqlMigrationMode(OfflineValue);
        /// <summary> Online. </summary>
        public static PostgreSqlMigrationMode Online { get; } = new PostgreSqlMigrationMode(OnlineValue);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationMode"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlMigrationMode left, PostgreSqlMigrationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationMode"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlMigrationMode left, PostgreSqlMigrationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlMigrationMode"/>. </summary>
        public static implicit operator PostgreSqlMigrationMode(string value) => new PostgreSqlMigrationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlMigrationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlMigrationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
