// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Indicates whether to setup LogicalReplicationOnSourceDb, if needed. </summary>
    public readonly partial struct PostgreSqlMigrationLogicalReplicationOnSourceDb : IEquatable<PostgreSqlMigrationLogicalReplicationOnSourceDb>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationLogicalReplicationOnSourceDb"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlMigrationLogicalReplicationOnSourceDb(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";

        /// <summary> True. </summary>
        public static PostgreSqlMigrationLogicalReplicationOnSourceDb True { get; } = new PostgreSqlMigrationLogicalReplicationOnSourceDb(TrueValue);
        /// <summary> False. </summary>
        public static PostgreSqlMigrationLogicalReplicationOnSourceDb False { get; } = new PostgreSqlMigrationLogicalReplicationOnSourceDb(FalseValue);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationLogicalReplicationOnSourceDb"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlMigrationLogicalReplicationOnSourceDb left, PostgreSqlMigrationLogicalReplicationOnSourceDb right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlMigrationLogicalReplicationOnSourceDb"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlMigrationLogicalReplicationOnSourceDb left, PostgreSqlMigrationLogicalReplicationOnSourceDb right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlMigrationLogicalReplicationOnSourceDb"/>. </summary>
        public static implicit operator PostgreSqlMigrationLogicalReplicationOnSourceDb(string value) => new PostgreSqlMigrationLogicalReplicationOnSourceDb(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlMigrationLogicalReplicationOnSourceDb other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlMigrationLogicalReplicationOnSourceDb other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
