// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Server admin credentials. </summary>
    public partial class PostgreSqlMigrationAdminCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationAdminCredentials"/>. </summary>
        /// <param name="sourceServerPassword"> Password for source server. </param>
        /// <param name="targetServerPassword"> Password for target server. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceServerPassword"/> or <paramref name="targetServerPassword"/> is null. </exception>
        public PostgreSqlMigrationAdminCredentials(string sourceServerPassword, string targetServerPassword)
        {
            Argument.AssertNotNull(sourceServerPassword, nameof(sourceServerPassword));
            Argument.AssertNotNull(targetServerPassword, nameof(targetServerPassword));

            SourceServerPassword = sourceServerPassword;
            TargetServerPassword = targetServerPassword;
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationAdminCredentials"/>. </summary>
        /// <param name="sourceServerPassword"> Password for source server. </param>
        /// <param name="targetServerPassword"> Password for target server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlMigrationAdminCredentials(string sourceServerPassword, string targetServerPassword, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceServerPassword = sourceServerPassword;
            TargetServerPassword = targetServerPassword;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlMigrationAdminCredentials"/> for deserialization. </summary>
        internal PostgreSqlMigrationAdminCredentials()
        {
        }

        /// <summary> Password for source server. </summary>
        [WirePath("sourceServerPassword")]
        public string SourceServerPassword { get; set; }
        /// <summary> Password for target server. </summary>
        [WirePath("targetServerPassword")]
        public string TargetServerPassword { get; set; }
    }
}
