// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Primary encryption key status for Data encryption enabled server. </summary>
    public readonly partial struct PostgreSqlKeyStatus : IEquatable<PostgreSqlKeyStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlKeyStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlKeyStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";

        /// <summary> Valid. </summary>
        public static PostgreSqlKeyStatus Valid { get; } = new PostgreSqlKeyStatus(ValidValue);
        /// <summary> Invalid. </summary>
        public static PostgreSqlKeyStatus Invalid { get; } = new PostgreSqlKeyStatus(InvalidValue);
        /// <summary> Determines if two <see cref="PostgreSqlKeyStatus"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlKeyStatus left, PostgreSqlKeyStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlKeyStatus"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlKeyStatus left, PostgreSqlKeyStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlKeyStatus"/>. </summary>
        public static implicit operator PostgreSqlKeyStatus(string value) => new PostgreSqlKeyStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlKeyStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlKeyStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
