// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Validation status for migration. </summary>
    public readonly partial struct PostgreSqlFlexibleServersValidationState : IEquatable<PostgreSqlFlexibleServersValidationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersValidationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersValidationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string WarningValue = "Warning";

        /// <summary> Failed. </summary>
        public static PostgreSqlFlexibleServersValidationState Failed { get; } = new PostgreSqlFlexibleServersValidationState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static PostgreSqlFlexibleServersValidationState Succeeded { get; } = new PostgreSqlFlexibleServersValidationState(SucceededValue);
        /// <summary> Warning. </summary>
        public static PostgreSqlFlexibleServersValidationState Warning { get; } = new PostgreSqlFlexibleServersValidationState(WarningValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersValidationState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersValidationState left, PostgreSqlFlexibleServersValidationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersValidationState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersValidationState left, PostgreSqlFlexibleServersValidationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersValidationState"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersValidationState(string value) => new PostgreSqlFlexibleServersValidationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersValidationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersValidationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
