// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    public partial class PostgreSqlFlexibleServersValidationDetails : IUtf8JsonSerializable, IJsonModel<PostgreSqlFlexibleServersValidationDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PostgreSqlFlexibleServersValidationDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PostgreSqlFlexibleServersValidationDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServersValidationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlFlexibleServersValidationDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (Optional.IsDefined(ValidationStartTimeInUtc))
            {
                writer.WritePropertyName("validationStartTimeInUtc"u8);
                writer.WriteStringValue(ValidationStartTimeInUtc.Value, "O");
            }
            if (Optional.IsDefined(ValidationEndTimeInUtc))
            {
                writer.WritePropertyName("validationEndTimeInUtc"u8);
                writer.WriteStringValue(ValidationEndTimeInUtc.Value, "O");
            }
            if (Optional.IsCollectionDefined(ServerLevelValidationDetails))
            {
                writer.WritePropertyName("serverLevelValidationDetails"u8);
                writer.WriteStartArray();
                foreach (var item in ServerLevelValidationDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(DbLevelValidationDetails))
            {
                writer.WritePropertyName("dbLevelValidationDetails"u8);
                writer.WriteStartArray();
                foreach (var item in DbLevelValidationDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PostgreSqlFlexibleServersValidationDetails IJsonModel<PostgreSqlFlexibleServersValidationDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServersValidationDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PostgreSqlFlexibleServersValidationDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePostgreSqlFlexibleServersValidationDetails(document.RootElement, options);
        }

        internal static PostgreSqlFlexibleServersValidationDetails DeserializePostgreSqlFlexibleServersValidationDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PostgreSqlFlexibleServersValidationState? status = default;
            DateTimeOffset? validationStartTimeInUtc = default;
            DateTimeOffset? validationEndTimeInUtc = default;
            IReadOnlyList<ValidationSummaryItem> serverLevelValidationDetails = default;
            IReadOnlyList<DbLevelValidationStatus> dbLevelValidationDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new PostgreSqlFlexibleServersValidationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("validationStartTimeInUtc"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationStartTimeInUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("validationEndTimeInUtc"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    validationEndTimeInUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("serverLevelValidationDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ValidationSummaryItem> array = new List<ValidationSummaryItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ValidationSummaryItem.DeserializeValidationSummaryItem(item, options));
                    }
                    serverLevelValidationDetails = array;
                    continue;
                }
                if (property.NameEquals("dbLevelValidationDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DbLevelValidationStatus> array = new List<DbLevelValidationStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DbLevelValidationStatus.DeserializeDbLevelValidationStatus(item, options));
                    }
                    dbLevelValidationDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PostgreSqlFlexibleServersValidationDetails(
                status,
                validationStartTimeInUtc,
                validationEndTimeInUtc,
                serverLevelValidationDetails ?? new ChangeTrackingList<ValidationSummaryItem>(),
                dbLevelValidationDetails ?? new ChangeTrackingList<DbLevelValidationStatus>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationStartTimeInUtc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationStartTimeInUtc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationStartTimeInUtc))
                {
                    builder.Append("  validationStartTimeInUtc: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ValidationStartTimeInUtc.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidationEndTimeInUtc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  validationEndTimeInUtc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidationEndTimeInUtc))
                {
                    builder.Append("  validationEndTimeInUtc: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ValidationEndTimeInUtc.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServerLevelValidationDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  serverLevelValidationDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ServerLevelValidationDetails))
                {
                    if (ServerLevelValidationDetails.Any())
                    {
                        builder.Append("  serverLevelValidationDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in ServerLevelValidationDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  serverLevelValidationDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DbLevelValidationDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dbLevelValidationDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DbLevelValidationDetails))
                {
                    if (DbLevelValidationDetails.Any())
                    {
                        builder.Append("  dbLevelValidationDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in DbLevelValidationDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dbLevelValidationDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PostgreSqlFlexibleServersValidationDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServersValidationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlFlexibleServersValidationDetails)} does not support writing '{options.Format}' format.");
            }
        }

        PostgreSqlFlexibleServersValidationDetails IPersistableModel<PostgreSqlFlexibleServersValidationDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PostgreSqlFlexibleServersValidationDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePostgreSqlFlexibleServersValidationDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PostgreSqlFlexibleServersValidationDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PostgreSqlFlexibleServersValidationDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
