// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Storage type for the server. Allowed values are Premium_LRS and PremiumV2_LRS, and default is Premium_LRS if not specified. </summary>
    public readonly partial struct PostgreSqlFlexibleServersStorageType : IEquatable<PostgreSqlFlexibleServersStorageType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersStorageType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersStorageType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PremiumLRSValue = "Premium_LRS";
        private const string PremiumV2LRSValue = "PremiumV2_LRS";

        /// <summary> Premium_LRS. </summary>
        public static PostgreSqlFlexibleServersStorageType PremiumLRS { get; } = new PostgreSqlFlexibleServersStorageType(PremiumLRSValue);
        /// <summary> PremiumV2_LRS. </summary>
        public static PostgreSqlFlexibleServersStorageType PremiumV2LRS { get; } = new PostgreSqlFlexibleServersStorageType(PremiumV2LRSValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersStorageType"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersStorageType left, PostgreSqlFlexibleServersStorageType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersStorageType"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersStorageType left, PostgreSqlFlexibleServersStorageType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersStorageType"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersStorageType(string value) => new PostgreSqlFlexibleServersStorageType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersStorageType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersStorageType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
