// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Supported SSL modes for migration. VerifyFull is the recommended SSL mode for Single server migration. Prefer, Require are recommended SSL modes for other source types. </summary>
    public readonly partial struct PostgreSqlFlexibleServersSslMode : IEquatable<PostgreSqlFlexibleServersSslMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersSslMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersSslMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreferValue = "Prefer";
        private const string RequireValue = "Require";
        private const string VerifyCAValue = "VerifyCA";
        private const string VerifyFullValue = "VerifyFull";

        /// <summary> Prefer. </summary>
        public static PostgreSqlFlexibleServersSslMode Prefer { get; } = new PostgreSqlFlexibleServersSslMode(PreferValue);
        /// <summary> Require. </summary>
        public static PostgreSqlFlexibleServersSslMode Require { get; } = new PostgreSqlFlexibleServersSslMode(RequireValue);
        /// <summary> VerifyCA. </summary>
        public static PostgreSqlFlexibleServersSslMode VerifyCA { get; } = new PostgreSqlFlexibleServersSslMode(VerifyCAValue);
        /// <summary> VerifyFull. </summary>
        public static PostgreSqlFlexibleServersSslMode VerifyFull { get; } = new PostgreSqlFlexibleServersSslMode(VerifyFullValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersSslMode"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersSslMode left, PostgreSqlFlexibleServersSslMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersSslMode"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersSslMode left, PostgreSqlFlexibleServersSslMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersSslMode"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersSslMode(string value) => new PostgreSqlFlexibleServersSslMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersSslMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersSslMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
