// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Migration source server type : OnPremises, AWS, GCP, AzureVM, PostgreSQLSingleServer, AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB. </summary>
    public readonly partial struct PostgreSqlFlexibleServersSourceType : IEquatable<PostgreSqlFlexibleServersSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnPremisesValue = "OnPremises";
        private const string AWSValue = "AWS";
        private const string GCPValue = "GCP";
        private const string AzureVmValue = "AzureVM";
        private const string PostgreSQLSingleServerValue = "PostgreSQLSingleServer";
        private const string AWSRDSValue = "AWS_RDS";
        private const string AWSAuroraValue = "AWS_AURORA";
        private const string AWSEC2Value = "AWS_EC2";
        private const string GCPCloudSQLValue = "GCP_CloudSQL";
        private const string GCPAlloyDBValue = "GCP_AlloyDB";
        private const string GCPComputeValue = "GCP_Compute";
        private const string EDBValue = "EDB";

        /// <summary> OnPremises. </summary>
        public static PostgreSqlFlexibleServersSourceType OnPremises { get; } = new PostgreSqlFlexibleServersSourceType(OnPremisesValue);
        /// <summary> AWS. </summary>
        public static PostgreSqlFlexibleServersSourceType AWS { get; } = new PostgreSqlFlexibleServersSourceType(AWSValue);
        /// <summary> GCP. </summary>
        public static PostgreSqlFlexibleServersSourceType GCP { get; } = new PostgreSqlFlexibleServersSourceType(GCPValue);
        /// <summary> AzureVM. </summary>
        public static PostgreSqlFlexibleServersSourceType AzureVm { get; } = new PostgreSqlFlexibleServersSourceType(AzureVmValue);
        /// <summary> PostgreSQLSingleServer. </summary>
        public static PostgreSqlFlexibleServersSourceType PostgreSQLSingleServer { get; } = new PostgreSqlFlexibleServersSourceType(PostgreSQLSingleServerValue);
        /// <summary> AWS_RDS. </summary>
        public static PostgreSqlFlexibleServersSourceType AWSRDS { get; } = new PostgreSqlFlexibleServersSourceType(AWSRDSValue);
        /// <summary> AWS_AURORA. </summary>
        public static PostgreSqlFlexibleServersSourceType AWSAurora { get; } = new PostgreSqlFlexibleServersSourceType(AWSAuroraValue);
        /// <summary> AWS_EC2. </summary>
        public static PostgreSqlFlexibleServersSourceType AWSEC2 { get; } = new PostgreSqlFlexibleServersSourceType(AWSEC2Value);
        /// <summary> GCP_CloudSQL. </summary>
        public static PostgreSqlFlexibleServersSourceType GCPCloudSQL { get; } = new PostgreSqlFlexibleServersSourceType(GCPCloudSQLValue);
        /// <summary> GCP_AlloyDB. </summary>
        public static PostgreSqlFlexibleServersSourceType GCPAlloyDB { get; } = new PostgreSqlFlexibleServersSourceType(GCPAlloyDBValue);
        /// <summary> GCP_Compute. </summary>
        public static PostgreSqlFlexibleServersSourceType GCPCompute { get; } = new PostgreSqlFlexibleServersSourceType(GCPComputeValue);
        /// <summary> EDB. </summary>
        public static PostgreSqlFlexibleServersSourceType EDB { get; } = new PostgreSqlFlexibleServersSourceType(EDBValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersSourceType"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersSourceType left, PostgreSqlFlexibleServersSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersSourceType"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersSourceType left, PostgreSqlFlexibleServersSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersSourceType"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersSourceType(string value) => new PostgreSqlFlexibleServersSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
