// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Gets the replication state of a replica server. This property is returned only for replicas api call. Supported values are Active, Catchup, Provisioning, Updating, Broken, Reconfiguring. </summary>
    public readonly partial struct PostgreSqlFlexibleServersReplicationState : IEquatable<PostgreSqlFlexibleServersReplicationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersReplicationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersReplicationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string CatchupValue = "Catchup";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string BrokenValue = "Broken";
        private const string ReconfiguringValue = "Reconfiguring";

        /// <summary> Active. </summary>
        public static PostgreSqlFlexibleServersReplicationState Active { get; } = new PostgreSqlFlexibleServersReplicationState(ActiveValue);
        /// <summary> Catchup. </summary>
        public static PostgreSqlFlexibleServersReplicationState Catchup { get; } = new PostgreSqlFlexibleServersReplicationState(CatchupValue);
        /// <summary> Provisioning. </summary>
        public static PostgreSqlFlexibleServersReplicationState Provisioning { get; } = new PostgreSqlFlexibleServersReplicationState(ProvisioningValue);
        /// <summary> Updating. </summary>
        public static PostgreSqlFlexibleServersReplicationState Updating { get; } = new PostgreSqlFlexibleServersReplicationState(UpdatingValue);
        /// <summary> Broken. </summary>
        public static PostgreSqlFlexibleServersReplicationState Broken { get; } = new PostgreSqlFlexibleServersReplicationState(BrokenValue);
        /// <summary> Reconfiguring. </summary>
        public static PostgreSqlFlexibleServersReplicationState Reconfiguring { get; } = new PostgreSqlFlexibleServersReplicationState(ReconfiguringValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersReplicationState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersReplicationState left, PostgreSqlFlexibleServersReplicationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersReplicationState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersReplicationState left, PostgreSqlFlexibleServersReplicationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersReplicationState"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersReplicationState(string value) => new PostgreSqlFlexibleServersReplicationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersReplicationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersReplicationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
