// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> Replica properties of a server. </summary>
    public partial class PostgreSqlFlexibleServersReplica
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersReplica"/>. </summary>
        public PostgreSqlFlexibleServersReplica()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersReplica"/>. </summary>
        /// <param name="role"> Used to indicate role of the server in replication set. </param>
        /// <param name="capacity"> Replicas allowed for a server. </param>
        /// <param name="replicationState"> Gets the replication state of a replica server. This property is returned only for replicas api call. Supported values are Active, Catchup, Provisioning, Updating, Broken, Reconfiguring. </param>
        /// <param name="promoteMode"> Sets the promote mode for a replica server. This is a write only property. </param>
        /// <param name="promoteOption"> Sets the promote options for a replica server. This is a write only property. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PostgreSqlFlexibleServersReplica(PostgreSqlFlexibleServerReplicationRole? role, int? capacity, PostgreSqlFlexibleServersReplicationState? replicationState, ReadReplicaPromoteMode? promoteMode, ReplicationPromoteOption? promoteOption, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Role = role;
            Capacity = capacity;
            ReplicationState = replicationState;
            PromoteMode = promoteMode;
            PromoteOption = promoteOption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Used to indicate role of the server in replication set. </summary>
        [WirePath("role")]
        public PostgreSqlFlexibleServerReplicationRole? Role { get; set; }
        /// <summary> Replicas allowed for a server. </summary>
        [WirePath("capacity")]
        public int? Capacity { get; }
        /// <summary> Gets the replication state of a replica server. This property is returned only for replicas api call. Supported values are Active, Catchup, Provisioning, Updating, Broken, Reconfiguring. </summary>
        [WirePath("replicationState")]
        public PostgreSqlFlexibleServersReplicationState? ReplicationState { get; }
        /// <summary> Sets the promote mode for a replica server. This is a write only property. </summary>
        [WirePath("promoteMode")]
        public ReadReplicaPromoteMode? PromoteMode { get; set; }
        /// <summary> Sets the promote options for a replica server. This is a write only property. </summary>
        [WirePath("promoteOption")]
        public ReplicationPromoteOption? PromoteOption { get; set; }
    }
}
