// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState : IEquatable<PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState Succeeded { get; } = new PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState Creating { get; } = new PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState Deleting { get; } = new PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState Failed { get; } = new PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState left, PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState left, PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(string value) => new PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServersPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
