// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.PostgreSql.FlexibleServers.Models
{
    /// <summary> A value indicating whether this region is restricted. "Enabled" means region is restricted. "Disabled" stands for region is not restricted. </summary>
    public readonly partial struct PostgreSqlFlexibleServerZoneRedundantRestricted : IEquatable<PostgreSqlFlexibleServerZoneRedundantRestricted>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostgreSqlFlexibleServerZoneRedundantRestricted"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostgreSqlFlexibleServerZoneRedundantRestricted(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static PostgreSqlFlexibleServerZoneRedundantRestricted Enabled { get; } = new PostgreSqlFlexibleServerZoneRedundantRestricted(EnabledValue);
        /// <summary> Disabled. </summary>
        public static PostgreSqlFlexibleServerZoneRedundantRestricted Disabled { get; } = new PostgreSqlFlexibleServerZoneRedundantRestricted(DisabledValue);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerZoneRedundantRestricted"/> values are the same. </summary>
        public static bool operator ==(PostgreSqlFlexibleServerZoneRedundantRestricted left, PostgreSqlFlexibleServerZoneRedundantRestricted right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostgreSqlFlexibleServerZoneRedundantRestricted"/> values are not the same. </summary>
        public static bool operator !=(PostgreSqlFlexibleServerZoneRedundantRestricted left, PostgreSqlFlexibleServerZoneRedundantRestricted right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostgreSqlFlexibleServerZoneRedundantRestricted"/>. </summary>
        public static implicit operator PostgreSqlFlexibleServerZoneRedundantRestricted(string value) => new PostgreSqlFlexibleServerZoneRedundantRestricted(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostgreSqlFlexibleServerZoneRedundantRestricted other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostgreSqlFlexibleServerZoneRedundantRestricted other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
